/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircleBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ShapeSphereBlocky
extends ShapeCircleBase {
    public ShapeSphereBlocky() {
        this(ShapeType.SPHERE_BLOCKY, Configs.Colors.SHAPE_SPHERE_BLOCKY.getColor(), 16.0);
    }

    public ShapeSphereBlocky(ShapeType type, Color4f color, double radius) {
        super(type, color, radius);
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        this.renderSphereShape(cameraPos);
        this.needsUpdate = false;
    }

    protected SphereUtils.RingPositionTest getPositionTest() {
        return (x, y, z, dir) -> SphereUtils.isPositionInsideOrClosestToRadiusOnBlockRing(x, y, z, this.getEffectiveCenter(), this.getSquaredRadius(), Direction.EAST);
    }

    protected double getTotalRadius() {
        return this.getRadius();
    }

    protected void renderSphereShape(Vec3 cameraPos) {
        SphereUtils.RingPositionTest test = this.getPositionTest();
        LongOpenHashSet positions = new LongOpenHashSet();
        Consumer<BlockPos.MutableBlockPos> positionConsumer = this.getPositionCollector(positions);
        BlockPos centerPos = this.getCenterBlock();
        double expand = 0.0;
        SphereUtils.collectSpherePositions(positionConsumer, test, centerPos, (int)this.getTotalRadius());
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        if (this.getCombineQuads()) {
            List<SideQuad> quads = SphereUtils.buildSphereShellToQuads(positions, this.mainAxis.m_122434_(), test, this.renderType, this.layerRange);
            RenderUtils.renderQuads(quads, this.color, expand, cameraPos, BUFFER_1);
        } else {
            RenderUtils.renderCircleBlockPositions(positions, PositionUtils.ALL_DIRECTIONS, test, this.renderType, this.layerRange, this.color, expand, cameraPos, BUFFER_1);
        }
        renderQuads.uploadData(BUFFER_1);
    }
}

