/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ShapeBox
extends ShapeBase {
    public static final AABB DEFAULT_BOX = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final double MAX_DIMENSIONS = 10000.0;
    protected AABB box = DEFAULT_BOX;
    protected AABB renderPerimeter = DEFAULT_BOX;
    protected int enabledSidesMask = 63;
    protected double maxDimensions = 10000.0;
    protected boolean gridEnabled = true;
    protected Vec3 gridSize = new Vec3(16.0, 16.0, 16.0);
    protected Vec3 gridStartOffset = Vec3.f_82478_;
    protected Vec3 gridEndOffset = Vec3.f_82478_;

    public ShapeBox() {
        super(ShapeType.BOX, Configs.Colors.SHAPE_BOX.getColor());
    }

    public AABB getBox() {
        return this.box;
    }

    public int getEnabledSidesMask() {
        return this.enabledSidesMask;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public Vec3 getGridSize() {
        return this.gridSize;
    }

    public Vec3 getGridStartOffset() {
        return this.gridStartOffset;
    }

    public Vec3 getGridEndOffset() {
        return this.gridEndOffset;
    }

    public void setBox(AABB box) {
        this.box = this.clampBox(box, this.maxDimensions);
        double margin = (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() * 16 * 2;
        this.renderPerimeter = box.m_82400_(margin);
        this.setNeedsUpdate();
    }

    protected AABB clampBox(AABB box, double maxSize) {
        if (Math.abs(box.f_82291_ - box.f_82288_) > maxSize || Math.abs(box.f_82292_ - box.f_82289_) > maxSize || Math.abs(box.f_82293_ - box.f_82290_) > maxSize) {
            box = DEFAULT_BOX;
        }
        return box;
    }

    public void setEnabledSidesMask(int enabledSidesMask) {
        this.enabledSidesMask = enabledSidesMask;
        this.setNeedsUpdate();
    }

    public void toggleGridEnabled() {
        this.gridEnabled = !this.gridEnabled;
        this.setNeedsUpdate();
    }

    public void setGridSize(Vec3 gridSize) {
        double x = Mth.m_14008_((double)gridSize.f_82479_, (double)0.5, (double)1024.0);
        double y = Mth.m_14008_((double)gridSize.f_82480_, (double)0.5, (double)1024.0);
        double z = Mth.m_14008_((double)gridSize.f_82481_, (double)0.5, (double)1024.0);
        this.gridSize = new Vec3(x, y, z);
        this.setNeedsUpdate();
    }

    public void setGridStartOffset(Vec3 gridStartOffset) {
        double x = Mth.m_14008_((double)gridStartOffset.f_82479_, (double)0.0, (double)1024.0);
        double y = Mth.m_14008_((double)gridStartOffset.f_82480_, (double)0.0, (double)1024.0);
        double z = Mth.m_14008_((double)gridStartOffset.f_82481_, (double)0.0, (double)1024.0);
        this.gridStartOffset = new Vec3(x, y, z);
        this.setNeedsUpdate();
    }

    public void setGridEndOffset(Vec3 gridEndOffset) {
        double x = Mth.m_14008_((double)gridEndOffset.f_82479_, (double)0.0, (double)1024.0);
        double y = Mth.m_14008_((double)gridEndOffset.f_82480_, (double)0.0, (double)1024.0);
        double z = Mth.m_14008_((double)gridEndOffset.f_82481_, (double)0.0, (double)1024.0);
        this.gridEndOffset = new Vec3(x, y, z);
        this.setNeedsUpdate();
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        Entity entity = EntityUtils.getCameraEntity();
        return super.shouldRender(mc) && entity != null && this.renderPerimeter.m_82390_(entity.m_20182_());
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        BUFFER_2.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
        AABB box = this.box.m_82386_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        this.renderBox(box);
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        this.needsUpdate = false;
    }

    protected void renderBox(AABB box) {
        for (Direction side : PositionUtils.ALL_DIRECTIONS) {
            if (!ShapeBox.isSideEnabled(side, this.enabledSidesMask)) continue;
            ShapeBox.renderBoxSideQuad(box, side, this.color, BUFFER_1);
        }
        Color4f color = Color4f.fromColor((Color4f)this.color, (float)1.0f);
        ShapeBox.renderBoxEnabledEdgeLines(box, color, this.enabledSidesMask, BUFFER_2);
        if (this.gridEnabled) {
            this.renderGridLines(box, color);
        }
    }

    protected void renderGridLines(AABB box, Color4f color) {
        if (ShapeBox.isSideEnabled(Direction.DOWN, this.enabledSidesMask)) {
            this.renderGridLinesY(box, box.f_82289_, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(Direction.UP, this.enabledSidesMask)) {
            this.renderGridLinesY(box, box.f_82292_, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(Direction.NORTH, this.enabledSidesMask)) {
            this.renderGridLinesZ(box, box.f_82290_, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(Direction.SOUTH, this.enabledSidesMask)) {
            this.renderGridLinesZ(box, box.f_82293_, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(Direction.WEST, this.enabledSidesMask)) {
            this.renderGridLinesX(box, box.f_82288_, color, BUFFER_2);
        }
        if (ShapeBox.isSideEnabled(Direction.EAST, this.enabledSidesMask)) {
            this.renderGridLinesX(box, box.f_82291_, color, BUFFER_2);
        }
    }

    protected void renderGridLinesX(AABB box, double x, Color4f color, BufferBuilder buffer) {
        double end = box.f_82292_ - this.gridEndOffset.f_82480_;
        double min = box.f_82290_ + this.gridStartOffset.f_82481_;
        double max = box.f_82293_ - this.gridEndOffset.f_82481_;
        for (double y = box.f_82289_ + this.gridStartOffset.f_82480_; y <= end; y += this.gridSize.f_82480_) {
            buffer.m_5483_(x, y, min).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(x, y, max).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        end = box.f_82293_ - this.gridEndOffset.f_82481_;
        min = box.f_82289_ + this.gridStartOffset.f_82480_;
        max = box.f_82292_ - this.gridEndOffset.f_82480_;
        for (double z = box.f_82290_ + this.gridStartOffset.f_82481_; z <= end; z += this.gridSize.f_82481_) {
            buffer.m_5483_(x, min, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(x, max, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
    }

    protected void renderGridLinesY(AABB box, double y, Color4f color, BufferBuilder buffer) {
        double end = box.f_82291_ - this.gridEndOffset.f_82479_;
        double min = box.f_82290_ + this.gridStartOffset.f_82481_;
        double max = box.f_82293_ - this.gridEndOffset.f_82481_;
        for (double x = box.f_82288_ + this.gridStartOffset.f_82479_; x <= end; x += this.gridSize.f_82479_) {
            buffer.m_5483_(x, y, min).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(x, y, max).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        end = box.f_82293_ - this.gridEndOffset.f_82481_;
        min = box.f_82288_ + this.gridStartOffset.f_82479_;
        max = box.f_82291_ - this.gridEndOffset.f_82479_;
        for (double z = box.f_82290_ + this.gridStartOffset.f_82481_; z <= end; z += this.gridSize.f_82481_) {
            buffer.m_5483_(min, y, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(max, y, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
    }

    protected void renderGridLinesZ(AABB box, double z, Color4f color, BufferBuilder buffer) {
        double end = box.f_82291_ - this.gridEndOffset.f_82479_;
        double min = box.f_82289_ + this.gridStartOffset.f_82480_;
        double max = box.f_82292_ - this.gridEndOffset.f_82480_;
        for (double x = box.f_82288_ + this.gridStartOffset.f_82479_; x <= end; x += this.gridSize.f_82479_) {
            buffer.m_5483_(x, min, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(x, max, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        end = box.f_82292_ - this.gridEndOffset.f_82480_;
        min = box.f_82288_ + this.gridStartOffset.f_82479_;
        max = box.f_82291_ - this.gridEndOffset.f_82479_;
        for (double y = box.f_82289_ + this.gridStartOffset.f_82480_; y <= end; y += this.gridSize.f_82480_) {
            buffer.m_5483_(min, y, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(max, y, z).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
    }

    public boolean isSideEnabled(Direction side) {
        return ShapeBox.isSideEnabled(side, this.enabledSidesMask);
    }

    public static boolean isSideEnabled(Direction side, int enabledSidesMask) {
        return (enabledSidesMask & 1 << side.m_122411_()) != 0;
    }

    public static void renderBoxSideQuad(AABB box, Direction side, Color4f color, BufferBuilder buffer) {
        switch (side) {
            case DOWN: {
                buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case UP: {
                buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case NORTH: {
                buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case SOUTH: {
                buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case WEST: {
                buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case EAST: {
                buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            }
        }
    }

    public static void renderBoxEnabledEdgeLines(AABB box, Color4f color, int enabledSidesMask, BufferBuilder buffer) {
        boolean down = ShapeBox.isSideEnabled(Direction.DOWN, enabledSidesMask);
        boolean up = ShapeBox.isSideEnabled(Direction.UP, enabledSidesMask);
        boolean north = ShapeBox.isSideEnabled(Direction.NORTH, enabledSidesMask);
        boolean south = ShapeBox.isSideEnabled(Direction.SOUTH, enabledSidesMask);
        boolean west = ShapeBox.isSideEnabled(Direction.WEST, enabledSidesMask);
        boolean east = ShapeBox.isSideEnabled(Direction.EAST, enabledSidesMask);
        if (down || north) {
            buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (up || north) {
            buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (down || south) {
            buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (up || south) {
            buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (down || west) {
            buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (up || west) {
            buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (down || east) {
            buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (up || east) {
            buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (north || west) {
            buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (south || west) {
            buffer.m_5483_(box.f_82288_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82288_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (north || east) {
            buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82290_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
        if (south || east) {
            buffer.m_5483_(box.f_82291_, box.f_82289_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            buffer.m_5483_(box.f_82291_, box.f_82292_, box.f_82293_).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        }
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        AABB box = this.box;
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.box.min_corner", (Object[])new Object[]{box.f_82288_, box.f_82289_, box.f_82290_}));
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.box.max_corner", (Object[])new Object[]{box.f_82291_, box.f_82292_, box.f_82293_}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.addProperty("enabled_sides", (Number)this.enabledSidesMask);
        obj.addProperty("grid_enabled", Boolean.valueOf(this.gridEnabled));
        obj.add("grid_size", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.gridSize));
        obj.add("grid_start_offset", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.gridStartOffset));
        obj.add("grid_end_offset", (JsonElement)JsonUtils.vec3dToJson((Vec3)this.gridEndOffset));
        obj.addProperty("minX", (Number)this.box.f_82288_);
        obj.addProperty("minY", (Number)this.box.f_82289_);
        obj.addProperty("minZ", (Number)this.box.f_82290_);
        obj.addProperty("maxX", (Number)this.box.f_82291_);
        obj.addProperty("maxY", (Number)this.box.f_82292_);
        obj.addProperty("maxZ", (Number)this.box.f_82293_);
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.enabledSidesMask = JsonUtils.getIntegerOrDefault((JsonObject)obj, (String)"enabled_sides", (int)63);
        this.gridEnabled = JsonUtils.getBooleanOrDefault((JsonObject)obj, (String)"grid_enabled", (boolean)true);
        this.gridSize = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"grid_size");
        this.gridStartOffset = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"grid_start_offset");
        this.gridEndOffset = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"grid_end_offset");
        if (this.gridSize == null) {
            this.gridSize = new Vec3(16.0, 16.0, 16.0);
        }
        if (this.gridStartOffset == null) {
            this.gridStartOffset = Vec3.f_82478_;
        }
        if (this.gridEndOffset == null) {
            this.gridEndOffset = Vec3.f_82478_;
        }
        double minX = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minX", (double)0.0);
        double minY = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minY", (double)0.0);
        double minZ = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minZ", (double)0.0);
        double maxX = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxX", (double)0.0);
        double maxY = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxY", (double)0.0);
        double maxZ = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxZ", (double)0.0);
        this.setBox(new AABB(minX, minY, minZ, maxX, maxY, maxZ));
    }
}

