/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class RenderUtils {
    public static void renderWallsWithLines(BlockPos posStart, BlockPos posEnd, Vec3 cameraPos, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        double minZ;
        double maxZ;
        double maxX;
        double minX;
        Entity entity = EntityUtils.getCameraEntity();
        int boxMinX = Math.min(posStart.m_123341_(), posEnd.m_123341_());
        int boxMinZ = Math.min(posStart.m_123343_(), posEnd.m_123343_());
        int boxMaxX = Math.max(posStart.m_123341_(), posEnd.m_123341_());
        int boxMaxZ = Math.max(posStart.m_123343_(), posEnd.m_123343_());
        int centerX = (int)Math.floor(entity.m_20185_());
        int centerZ = (int)Math.floor(entity.m_20189_());
        int maxDist = (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() * 32;
        int rangeMinX = centerX - maxDist;
        int rangeMinZ = centerZ - maxDist;
        int rangeMaxX = centerX + maxDist;
        int rangeMaxZ = centerZ + maxDist;
        double minY = Math.min(posStart.m_123342_(), posEnd.m_123342_());
        double maxY = Math.max(posStart.m_123342_(), posEnd.m_123342_()) + 1;
        if (rangeMinX <= boxMaxX && rangeMaxX >= boxMinX) {
            minX = Math.max(boxMinX, rangeMinX);
            maxX = Math.min(boxMaxX, rangeMaxX) + 1;
            if (rangeMinZ <= boxMinZ && rangeMaxZ >= boxMinZ) {
                minZ = maxZ = (double)boxMinZ;
                RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
            if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMaxZ) {
                minZ = maxZ = (double)(boxMaxZ + 1);
                RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
        }
        if (rangeMinZ <= boxMaxZ && rangeMaxZ >= boxMinZ) {
            minZ = Math.max(boxMinZ, rangeMinZ);
            maxZ = Math.min(boxMaxZ, rangeMaxZ) + 1;
            if (rangeMinX <= boxMinX && rangeMaxX >= boxMinX) {
                minX = maxX = (double)boxMinX;
                RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
            if (rangeMinX <= boxMaxX && rangeMaxX >= boxMaxX) {
                minX = maxX = (double)(boxMaxX + 1);
                RenderUtils.renderWallWithLines(minX, minY, minZ, maxX, maxY, maxZ, lineIntervalH, lineIntervalV, alignLinesToModulo, cameraPos, color, bufferQuads, bufferLines);
            }
        }
    }

    public static void renderWallWithLines(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, double lineIntervalH, double lineIntervalV, boolean alignLinesToModulo, Vec3 cameraPos, Color4f color, BufferBuilder bufferQuads, BufferBuilder bufferLines) {
        block4: {
            double lineX;
            double cz;
            double cy;
            double cx;
            block5: {
                double lineZ;
                cx = cameraPos.f_82479_;
                cy = cameraPos.f_82480_;
                cz = cameraPos.f_82481_;
                bufferQuads.m_5483_(minX - cx, maxY - cy, minZ - cz).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                bufferQuads.m_5483_(minX - cx, minY - cy, minZ - cz).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                bufferQuads.m_5483_(maxX - cx, minY - cy, maxZ - cz).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                bufferQuads.m_5483_(maxX - cx, maxY - cy, maxZ - cz).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                if (lineIntervalV > 0.0) {
                    double lineY;
                    double d = lineY = alignLinesToModulo ? RenderUtils.roundUp(minY, lineIntervalV) : minY;
                    while (lineY <= maxY) {
                        bufferLines.m_5483_(minX - cx, lineY - cy, minZ - cz).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
                        bufferLines.m_5483_(maxX - cx, lineY - cy, maxZ - cz).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
                        lineY += lineIntervalV;
                    }
                }
                if (!(lineIntervalH > 0.0)) break block4;
                if (minX != maxX) break block5;
                double d = lineZ = alignLinesToModulo ? RenderUtils.roundUp(minZ, lineIntervalH) : minZ;
                while (lineZ <= maxZ) {
                    bufferLines.m_5483_(minX - cx, minY - cy, lineZ - cz).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
                    bufferLines.m_5483_(minX - cx, maxY - cy, lineZ - cz).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
                    lineZ += lineIntervalH;
                }
                break block4;
            }
            if (minZ != maxZ) break block4;
            double d = lineX = alignLinesToModulo ? RenderUtils.roundUp(minX, lineIntervalH) : minX;
            while (lineX <= maxX) {
                bufferLines.m_5483_(lineX - cx, minY - cy, minZ - cz).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
                bufferLines.m_5483_(lineX - cx, maxY - cy, minZ - cz).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
                lineX += lineIntervalH;
            }
        }
    }

    public static void drawBlockSpaceSideBatchedQuads(long posLong, Direction side, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        int x = BlockPos.m_121983_((long)posLong);
        int y = BlockPos.m_122008_((long)posLong);
        int z = BlockPos.m_122015_((long)posLong);
        double offsetX = (double)x - cameraPos.f_82479_;
        double offsetY = (double)y - cameraPos.f_82480_;
        double offsetZ = (double)z - cameraPos.f_82481_;
        double minX = offsetX - expand;
        double minY = offsetY - expand;
        double minZ = offsetZ - expand;
        double maxX = offsetX + expand + 1.0;
        double maxY = offsetY + expand + 1.0;
        double maxZ = offsetZ + expand + 1.0;
        switch (side) {
            case DOWN: {
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case UP: {
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case NORTH: {
                buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case SOUTH: {
                buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case WEST: {
                buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case EAST: {
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            }
        }
    }

    public static void renderCircleBlockPositions(LongOpenHashSet positions, Direction[] sides, SphereUtils.RingPositionTest test, ShapeRenderType renderType, LayerRange range, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        boolean full = renderType == ShapeRenderType.FULL_BLOCK;
        boolean outer = renderType == ShapeRenderType.OUTER_EDGE;
        boolean inner = renderType == ShapeRenderType.INNER_EDGE;
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (Direction side : sides) {
                long adjPosLong = BlockPos.m_121915_((long)posLong, (Direction)side);
                if (positions.contains(adjPosLong)) continue;
                boolean render = full;
                if (!full) {
                    int adjX = BlockPos.m_121983_((long)adjPosLong);
                    int adjY = BlockPos.m_122008_((long)adjPosLong);
                    int adjZ = BlockPos.m_122015_((long)adjPosLong);
                    boolean onOrIn = test.isInsideOrCloserThan(adjX, adjY, adjZ, side);
                    boolean bl = render = outer && !onOrIn || inner && onOrIn;
                }
                if (!render) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderBlockPositions(LongOpenHashSet positions, LayerRange range, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        LongIterator longIterator = positions.iterator();
        while (longIterator.hasNext()) {
            long posLong = (Long)longIterator.next();
            if (!range.isPositionWithinRange(posLong)) continue;
            for (Direction side : PositionUtils.ALL_DIRECTIONS) {
                long adjPosLong = BlockPos.m_121915_((long)posLong, (Direction)side);
                if (positions.contains(adjPosLong)) continue;
                RenderUtils.drawBlockSpaceSideBatchedQuads(posLong, side, color, expand, cameraPos, buffer);
            }
        }
    }

    public static void renderQuads(Collection<SideQuad> quads, Color4f color, double expand, Vec3 cameraPos, BufferBuilder buffer) {
        for (SideQuad quad : quads) {
            RenderUtils.renderInsetQuad(quad.startPos(), quad.width(), quad.height(), quad.side(), -expand, color, cameraPos, buffer);
        }
    }

    public static void renderInsetQuad(Vec3i minPos, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        RenderUtils.renderInsetQuad(minPos.m_123341_(), minPos.m_123342_(), minPos.m_123343_(), width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(long minPos, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        int x = BlockPos.m_121983_((long)minPos);
        int y = BlockPos.m_122008_((long)minPos);
        int z = BlockPos.m_122015_((long)minPos);
        RenderUtils.renderInsetQuad(x, y, z, width, height, side, inset, color, cameraPos, buffer);
    }

    public static void renderInsetQuad(int x, int y, int z, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        double minX = (double)x - cameraPos.f_82479_;
        double minY = (double)y - cameraPos.f_82480_;
        double minZ = (double)z - cameraPos.f_82481_;
        double maxX = minX;
        double maxY = minY;
        double maxZ = minZ;
        if (side.m_122434_() == Direction.Axis.Z) {
            maxX += (double)width;
            maxY += (double)height;
        } else if (side.m_122434_() == Direction.Axis.X) {
            maxY += (double)height;
            maxZ += (double)width;
        } else if (side.m_122434_() == Direction.Axis.Y) {
            maxX += (double)width;
            maxZ += (double)height;
        }
        switch (side) {
            case WEST: {
                buffer.m_5483_(minX += inset, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case EAST: {
                buffer.m_5483_(maxX += 1.0 - inset, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case NORTH: {
                buffer.m_5483_(minX, minY, minZ += inset).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case SOUTH: {
                buffer.m_5483_(minX, minY, maxZ += 1.0 - inset).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case DOWN: {
                buffer.m_5483_(minX, minY += inset, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, minY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case UP: {
                buffer.m_5483_(minX, maxY += 1.0 - inset, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, minZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(maxX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
            }
        }
    }

    public static void renderBiomeBorderLines(Vec3i minPos, int width, int height, Direction side, double inset, Color4f color, Vec3 cameraPos, BufferBuilder buffer) {
        double minX = (double)minPos.m_123341_() - cameraPos.f_82479_;
        double minY = (double)minPos.m_123342_() - cameraPos.f_82480_;
        double minZ = (double)minPos.m_123343_() - cameraPos.f_82481_;
        switch (side) {
            case WEST: {
                minX += inset;
                break;
            }
            case EAST: {
                minX += 1.0 - inset;
                break;
            }
            case NORTH: {
                minZ += inset;
                break;
            }
            case SOUTH: {
                minZ += 1.0 - inset;
                break;
            }
            case DOWN: {
                minY += inset;
                break;
            }
            case UP: {
                minY += 1.0 - inset;
            }
        }
        double maxX = minX;
        double maxY = minY;
        double maxZ = minZ;
        if (side.m_122434_() == Direction.Axis.Z) {
            maxX += (double)width;
            maxY += (double)height;
        } else if (side.m_122434_() == Direction.Axis.X) {
            maxY += (double)height;
            maxZ += (double)width;
        } else if (side.m_122434_() == Direction.Axis.Y) {
            maxX += (double)width;
            maxZ += (double)height;
        }
        if (side.m_122434_() == Direction.Axis.Y) {
            buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
            buffer.m_5483_(minX, maxY, maxZ).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
            for (double z = minZ; z < maxZ + 0.5; z += 1.0) {
                buffer.m_5483_(minX, minY, z).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
                buffer.m_5483_(maxX, maxY, z).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
            }
        } else {
            buffer.m_5483_(minX, minY, minZ).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
            buffer.m_5483_(minX, maxY, minZ).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
            for (double y = minY; y < maxY + 0.5; y += 1.0) {
                buffer.m_5483_(minX, y, minZ).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
                buffer.m_5483_(maxX, y, maxZ).m_85950_(color.r, color.g, color.b, 1.0f).m_5752_();
            }
        }
    }

    public static double roundUp(double value, double interval) {
        double remainder;
        if (interval == 0.0) {
            return 0.0;
        }
        if (value == 0.0) {
            return interval;
        }
        if (value < 0.0) {
            interval *= -1.0;
        }
        return (remainder = value % interval) == 0.0 ? value : value + interval - remainder;
    }
}

