/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererSpawnChunks
extends OverlayRendererBase {
    protected static boolean needsUpdate = true;
    protected final RendererToggle toggle;
    protected final boolean isPlayerFollowing;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public OverlayRendererSpawnChunks(RendererToggle toggle) {
        this.toggle = toggle;
        this.isPlayerFollowing = toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER;
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return this.toggle.getBooleanValue() && (this.isPlayerFollowing || mc.f_91073_ != null && MiscUtils.isOverworld((Level)mc.f_91073_) && DataStorage.getInstance().isWorldSpawnKnown());
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        if (needsUpdate) {
            return true;
        }
        entity = this.isPlayerFollowing ? mc.f_91074_ : entity;
        int ex = (int)Math.floor(entity.m_20185_());
        int ez = (int)Math.floor(entity.m_20189_());
        int lx = this.lastUpdatePos.m_123341_();
        int lz = this.lastUpdatePos.m_123343_();
        if (this.isPlayerFollowing) {
            return ex != lx || ez != lz;
        }
        int range = (Integer)mc.f_91066_.m_231984_().m_231551_() * 16;
        return Math.abs(lx - ex) > range || Math.abs(lz - ez) > range;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        entity = this.isPlayerFollowing ? mc.f_91074_ : entity;
        DataStorage data = DataStorage.getInstance();
        BlockPos spawn = this.isPlayerFollowing ? PositionUtils.getEntityBlockPos((Entity)entity) : data.getWorldSpawn();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        BUFFER_2.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
        Color4f colorEntity = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getColor();
        Color4f colorLazy = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getColor();
        Color4f colorOuter = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_OUTER_OVERLAY_COLOR.getColor();
        fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((BlockPos)spawn, (Vec3)cameraPos, (Color4f)colorEntity, (double)0.001, (BufferBuilder)BUFFER_2);
        OverlayRendererSpawnChunks.drawBlockBoundingBoxSidesBatchedQuads(spawn, cameraPos, colorEntity, 0.001, BUFFER_1);
        Pair<BlockPos, BlockPos> corners = this.getSpawnChunkCorners(spawn, 22, (Level)mc.f_91073_);
        RenderUtils.renderWallsWithLines((BlockPos)corners.getLeft(), (BlockPos)corners.getRight(), cameraPos, 16.0, 16.0, true, colorOuter, BUFFER_1, BUFFER_2);
        corners = this.getSpawnChunkCorners(spawn, 11, (Level)mc.f_91073_);
        RenderUtils.renderWallsWithLines((BlockPos)corners.getLeft(), (BlockPos)corners.getRight(), cameraPos, 16.0, 16.0, true, colorLazy, BUFFER_1, BUFFER_2);
        corners = this.getSpawnChunkCorners(spawn, 9, (Level)mc.f_91073_);
        RenderUtils.renderWallsWithLines((BlockPos)corners.getLeft(), (BlockPos)corners.getRight(), cameraPos, 16.0, 16.0, true, colorEntity, BUFFER_1, BUFFER_2);
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }

    protected Pair<BlockPos, BlockPos> getSpawnChunkCorners(BlockPos worldSpawn, int chunkRange, Level world) {
        int cx = worldSpawn.m_123341_() >> 4;
        int cz = worldSpawn.m_123343_() >> 4;
        int minY = world != null ? world.m_141937_() : -64;
        int maxY = world != null ? world.m_151558_() : 320;
        BlockPos pos1 = new BlockPos(cx - chunkRange << 4, minY, cz - chunkRange << 4);
        BlockPos pos2 = new BlockPos((cx + chunkRange << 4) + 15, maxY, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(BlockPos pos, Vec3 cameraPos, Color4f color, double expand, BufferBuilder buffer) {
        double minX = (double)pos.m_123341_() - cameraPos.f_82479_ - expand;
        double minY = (double)pos.m_123342_() - cameraPos.f_82480_ - expand;
        double minZ = (double)pos.m_123343_() - cameraPos.f_82481_ - expand;
        double maxX = (double)pos.m_123341_() - cameraPos.f_82479_ + expand + 1.0;
        double maxY = (double)pos.m_123342_() - cameraPos.f_82480_ + expand + 1.0;
        double maxZ = (double)pos.m_123343_() - cameraPos.f_82481_ + expand + 1.0;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (BufferBuilder)buffer);
    }
}

