/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.network.IPluginChannelHandler;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.util.DataStorage;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class StructurePacketHandlerServux
implements IPluginChannelHandler {
    public static final int PROTOCOL_VERSION = 1;
    public static final int PACKET_S2C_METADATA = 1;
    public static final int PACKET_S2C_STRUCTURE_DATA = 2;
    public static final StructurePacketHandlerServux INSTANCE = new StructurePacketHandlerServux();
    private final ResourceLocation channel = new ResourceLocation("servux:structures");
    private final List<ResourceLocation> channels = ImmutableList.of((Object)this.channel);
    private boolean registered;
    private int timeout;

    public void reset() {
        this.registered = false;
    }

    public List<ResourceLocation> getChannels() {
        return this.channels;
    }

    public void onPacketReceived(FriendlyByteBuf buf) {
        CompoundTag tag;
        int id = buf.m_130242_();
        MiniHUD.printDebug("StructurePacketHandlerServux#onPacketReceived(): " + id, new Object[0]);
        if (id == 2 && this.registered) {
            CompoundTag tag2 = buf.m_130260_();
            if (tag2 != null) {
                ListTag structures = tag2.m_128437_("Structures", 10);
                DataStorage.getInstance().addOrUpdateStructuresFromServer(structures, this.timeout, true);
            }
        } else if (id == 1 && (tag = buf.m_130260_()) != null && tag.m_128451_("version") == 1 && tag.m_128461_("id").equals(this.channel.toString())) {
            this.timeout = tag.m_128451_("timeout");
            this.registered = true;
            DataStorage.getInstance().setIsServuxServer();
        }
    }
}

