/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ButtonOnOff;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetDropDownList;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.gui.GuiConfigs;
import fi.dy.masa.minihud.gui.widgets.WidgetListShapes;
import fi.dy.masa.minihud.gui.widgets.WidgetShapeEntry;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;

public class GuiShapeManager
extends GuiListBase<ShapeBase, WidgetShapeEntry, WidgetListShapes>
implements ISelectionListener<ShapeBase> {
    protected final WidgetDropDownList<ShapeType> widgetDropDown;
    protected final ButtonOnOff shapeRendererToggleButton;

    public GuiShapeManager() {
        super(10, 68);
        this.title = StringUtils.translate((String)"minihud.gui.title.shape_manager", (Object[])new Object[0]);
        this.shapeRendererToggleButton = new ButtonOnOff(10, 42, -1, false, "minihud.gui.button.shape_renderer_toggle", RendererToggle.SHAPE_RENDERER.getBooleanValue(), new String[0]);
        this.widgetDropDown = new WidgetDropDownList(0, 0, 160, 18, 200, 10, (List)ImmutableList.copyOf((Object[])ShapeType.values()), ShapeType::getDisplayName);
        this.widgetDropDown.setZLevel(100);
    }

    protected int getBrowserWidth() {
        return this.f_96543_ - 20;
    }

    protected int getBrowserHeight() {
        return this.f_96544_ - this.getListY() - 6;
    }

    public void initGui() {
        GuiConfigs.tab = GuiConfigs.ConfigGuiTab.SHAPES;
        super.initGui();
        this.clearWidgets();
        this.clearButtons();
        this.createTabButtons();
        ((WidgetListShapes)this.getListWidget()).refreshEntries();
    }

    protected void createTabButtons() {
        int x = 10;
        int y = 26;
        int rows = 1;
        for (GuiConfigs.ConfigGuiTab tab : GuiConfigs.ConfigGuiTab.values()) {
            int width = this.getStringWidth(tab.getDisplayName()) + 10;
            if (x >= this.f_96543_ - width - 10) {
                x = 10;
                y += 22;
                ++rows;
            }
            x += this.createTabButton(x, y, width, tab);
        }
        String name = StringUtils.translate((String)"minihud.gui.button.add_shape", (Object[])new Object[0]);
        ButtonGeneric addShapeButton = new ButtonGeneric(this.f_96543_ - 10, y, -1, true, name, new Object[0]);
        if (rows < 2 || this.f_96543_ - 10 - x < addShapeButton.getWidth() + this.widgetDropDown.getWidth() + 4) {
            y += 22;
        }
        addShapeButton.setY(y);
        this.setListPosition(this.getListX(), y + 20);
        this.reCreateListWidget();
        this.shapeRendererToggleButton.setPosition(10, y + 1);
        this.addButton((ButtonBase)this.shapeRendererToggleButton, (b, mb) -> this.toggleShapeRendererOnOff());
        this.widgetDropDown.setPosition(addShapeButton.getX() - this.widgetDropDown.getWidth() - 4, y + 1);
        this.addWidget((WidgetBase)this.widgetDropDown);
        this.addButton((ButtonBase)addShapeButton, (btn, mbtn) -> {
            ShapeType shape = (ShapeType)((Object)((Object)this.widgetDropDown.getSelectedEntry()));
            if (shape != null) {
                ShapeManager.INSTANCE.addShape(shape.createShape());
                ((WidgetListShapes)this.getListWidget()).refreshEntries();
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"Select the shape from the dropdown", (Object[])new Object[0]);
            }
        });
    }

    protected void toggleShapeRendererOnOff() {
        RendererToggle.SHAPE_RENDERER.toggleBooleanValue();
        this.shapeRendererToggleButton.updateDisplayString(RendererToggle.SHAPE_RENDERER.getBooleanValue());
    }

    protected int createTabButton(int x, int y, int width, GuiConfigs.ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListenerTab(tab));
        return button.getWidth() + 2;
    }

    public void onSelectionChange(@Nullable ShapeBase entry) {
        ShapeBase old = ShapeManager.INSTANCE.getSelectedShape();
        ShapeManager.INSTANCE.setSelectedShape(old == entry ? null : entry);
    }

    protected WidgetListShapes createListWidget(int listX, int listY) {
        return new WidgetListShapes(listX, listY, this.getBrowserWidth(), this.getBrowserHeight(), 0.0f, this);
    }

    public static class ButtonListenerTab
    implements IButtonActionListener {
        private final GuiConfigs.ConfigGuiTab tab;

        public ButtonListenerTab(GuiConfigs.ConfigGuiTab tab) {
            this.tab = tab;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            GuiConfigs.tab = this.tab;
            GuiBase.openGui((Screen)new GuiConfigs());
        }
    }
}

