/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin;

import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.menu.LecternAlbumMenu;
import io.github.mortuusars.exposure.mixin.LecternBlockEntityAccessor;
import io.github.mortuusars.exposure.util.ItemAndStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LecternBlock.class})
public abstract class LecternMixin {
    @Inject(method={"openScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void openScreen(Level level, BlockPos pos, Player player, CallbackInfo ci) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LecternBlockEntity) {
            LecternBlockEntity lecternBlockEntity = (LecternBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (lecternBlockEntity.m_59566_().m_41720_() instanceof AlbumItem) {
                    this.exposure$open(serverPlayer, lecternBlockEntity, lecternBlockEntity.m_59566_());
                    player.m_36220_(Stats.f_12974_);
                    ci.cancel();
                }
            }
        }
    }

    @Unique
    private void exposure$open(ServerPlayer player, final LecternBlockEntity lecternBlockEntity, final ItemStack albumStack) {
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return albumStack.m_41786_();
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                LecternBlockEntityAccessor accessor = (LecternBlockEntityAccessor)lecternBlockEntity;
                return new LecternAlbumMenu(containerId, lecternBlockEntity.m_58899_(), playerInventory, new ItemAndStack<AlbumItem>(albumStack), accessor.getBookAccess(), accessor.getDataAccess());
            }
        };
        PlatformHelper.openMenu(player, menuProvider, buffer -> {
            buffer.m_130064_(lecternBlockEntity.m_58899_());
            buffer.m_130055_(albumStack);
        });
    }
}

