/*
 * Decompiled with CFR 0.152.
 */
package io.github.lieonlion.mcv.init;

import io.github.lieonlion.mcv.block.MoreChestBlock;
import io.github.lieonlion.mcv.block.MoreTrappedChestBlock;
import io.github.lieonlion.mcv.block.entity.MoreChestBlockEntity;
import io.github.lieonlion.mcv.block.entity.MoreTrappedChestBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class McvBlockInit {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"lolmcv");
    private static final DeferredRegister<BlockEntityType<?>> BLOCKS_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"lolmcv");
    public static final RegistryObject<Block> OAK_CHEST = McvBlockInit.registerChest("oak", () -> new MoreChestBlock(MapColor.f_283825_, "oak"));
    public static final RegistryObject<Block> SPRUCE_CHEST = McvBlockInit.registerChest("spruce", () -> new MoreChestBlock(MapColor.f_283819_, "spruce"));
    public static final RegistryObject<Block> BIRCH_CHEST = McvBlockInit.registerChest("birch", () -> new MoreChestBlock(MapColor.f_283761_, "birch"));
    public static final RegistryObject<Block> JUNGLE_CHEST = McvBlockInit.registerChest("jungle", () -> new MoreChestBlock(MapColor.f_283762_, "jungle"));
    public static final RegistryObject<Block> ACACIA_CHEST = McvBlockInit.registerChest("acacia", () -> new MoreChestBlock(MapColor.f_283750_, "acacia"));
    public static final RegistryObject<Block> DARK_OAK_CHEST = McvBlockInit.registerChest("dark_oak", () -> new MoreChestBlock(MapColor.f_283748_, "dark_oak"));
    public static final RegistryObject<Block> MANGROVE_CHEST = McvBlockInit.registerChest("mangrove", () -> new MoreChestBlock(MapColor.f_283913_, "mangrove"));
    public static final RegistryObject<Block> CHERRY_CHEST = McvBlockInit.registerChest("cherry", () -> new MoreChestBlock(MapColor.f_283919_, SoundType.f_271497_, "cherry"));
    public static final RegistryObject<Block> BAMBOO_CHEST = McvBlockInit.registerChest("bamboo", () -> new MoreChestBlock(MapColor.f_283832_, SoundType.f_243772_, "bamboo"));
    public static final RegistryObject<Block> CRIMSON_CHEST = McvBlockInit.registerChest("crimson", () -> new MoreChestBlock(MapColor.f_283804_, SoundType.f_244244_, "crimson"));
    public static final RegistryObject<Block> WARPED_CHEST = McvBlockInit.registerChest("warped", () -> new MoreChestBlock(MapColor.f_283749_, SoundType.f_244244_, "warped"));
    public static final RegistryObject<Block> OAK_TRAPPED_CHEST = McvBlockInit.registerChest("oak_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283825_, "oak"));
    public static final RegistryObject<Block> SPRUCE_TRAPPED_CHEST = McvBlockInit.registerChest("spruce_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283819_, "spruce"));
    public static final RegistryObject<Block> BIRCH_TRAPPED_CHEST = McvBlockInit.registerChest("birch_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283761_, "birch"));
    public static final RegistryObject<Block> JUNGLE_TRAPPED_CHEST = McvBlockInit.registerChest("jungle_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283762_, "jungle"));
    public static final RegistryObject<Block> ACACIA_TRAPPED_CHEST = McvBlockInit.registerChest("acacia_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283750_, "acacia"));
    public static final RegistryObject<Block> DARK_OAK_TRAPPED_CHEST = McvBlockInit.registerChest("dark_oak_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283748_, "dark_oak"));
    public static final RegistryObject<Block> MANGROVE_TRAPPED_CHEST = McvBlockInit.registerChest("mangrove_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283913_, "mangrove"));
    public static final RegistryObject<Block> CHERRY_TRAPPED_CHEST = McvBlockInit.registerChest("cherry_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283919_, SoundType.f_271497_, "cherry"));
    public static final RegistryObject<Block> BAMBOO_TRAPPED_CHEST = McvBlockInit.registerChest("bamboo_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283832_, SoundType.f_243772_, "bamboo"));
    public static final RegistryObject<Block> CRIMSON_TRAPPED_CHEST = McvBlockInit.registerChest("crimson_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283804_, SoundType.f_244244_, "crimson"));
    public static final RegistryObject<Block> WARPED_TRAPPED_CHEST = McvBlockInit.registerChest("warped_trapped", () -> new MoreTrappedChestBlock(MapColor.f_283749_, SoundType.f_244244_, "warped"));
    public static RegistryObject<BlockEntityType<MoreChestBlockEntity>> MORE_CHEST_BLOCK_ENTITY;
    public static RegistryObject<BlockEntityType<MoreTrappedChestBlockEntity>> MORE_TRAPPED_CHEST_BLOCK_ENTITY;
    public static final List<RegistryObject<Block>> more_chest;
    public static final List<RegistryObject<Block>> more_trapped_chest;

    public static void registerBlocks(IEventBus modBus) {
        McvBlockInit.addToArray(OAK_CHEST, OAK_TRAPPED_CHEST);
        McvBlockInit.addToArray(SPRUCE_CHEST, SPRUCE_TRAPPED_CHEST);
        McvBlockInit.addToArray(BIRCH_CHEST, BIRCH_TRAPPED_CHEST);
        McvBlockInit.addToArray(JUNGLE_CHEST, JUNGLE_TRAPPED_CHEST);
        McvBlockInit.addToArray(ACACIA_CHEST, ACACIA_TRAPPED_CHEST);
        McvBlockInit.addToArray(DARK_OAK_CHEST, DARK_OAK_TRAPPED_CHEST);
        McvBlockInit.addToArray(MANGROVE_CHEST, MANGROVE_TRAPPED_CHEST);
        McvBlockInit.addToArray(CHERRY_CHEST, CHERRY_TRAPPED_CHEST);
        McvBlockInit.addToArray(BAMBOO_CHEST, BAMBOO_TRAPPED_CHEST);
        McvBlockInit.addToArray(CRIMSON_CHEST, CRIMSON_TRAPPED_CHEST);
        McvBlockInit.addToArray(WARPED_CHEST, WARPED_TRAPPED_CHEST);
        MORE_CHEST_BLOCK_ENTITY = BLOCKS_ENTITIES.register("chest_tile", () -> BlockEntityType.Builder.m_155273_(MoreChestBlockEntity::new, (Block[])((Block[])more_chest.stream().map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
        MORE_TRAPPED_CHEST_BLOCK_ENTITY = BLOCKS_ENTITIES.register("trapped_chest_tile", () -> BlockEntityType.Builder.m_155273_(MoreTrappedChestBlockEntity::new, (Block[])((Block[])more_trapped_chest.stream().map(RegistryObject::get).toArray(Block[]::new))).m_58966_(null));
        BLOCKS.register(modBus);
        BLOCKS_ENTITIES.register(modBus);
    }

    private static RegistryObject<Block> registerChest(String name, Supplier<Block> block) {
        return BLOCKS.register(name + "_chest", block);
    }

    private static void addToArray(RegistryObject<Block> chest, RegistryObject<Block> trappedChest) {
        more_chest.add(chest);
        more_trapped_chest.add(trappedChest);
    }

    static {
        more_chest = new ArrayList<RegistryObject<Block>>();
        more_trapped_chest = new ArrayList<RegistryObject<Block>>();
    }
}

