/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.peripheral;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kalrog.cc_printers_plus.Config;
import kalrog.cc_printers_plus.block.entity.PrinterBlockEntity;
import kalrog.cc_printers_plus.data.PrintData;
import kalrog.cc_printers_plus.data.Shape;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PrinterPeripheral
implements IPeripheral {
    private final PrinterBlockEntity blockEntity;

    public PrinterPeripheral(PrinterBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Nonnull
    public String getType() {
        return "3d_printer";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    @LuaFunction(mainThread=true)
    public final void reset() {
        this.blockEntity.setData(new PrintData());
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final String getLabel() {
        return this.blockEntity.getData().getLabel();
    }

    @LuaFunction(mainThread=true)
    public final void setLabel(Optional<String> label) {
        this.blockEntity.getData().setLabel(label.orElse(null));
        this.blockEntity.markDataDirty();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final String getTooltip() {
        return this.blockEntity.getData().getTooltip();
    }

    @LuaFunction(mainThread=true)
    public final void setTooltip(Optional<String> tooltip) {
        this.blockEntity.getData().setTooltip(tooltip.orElse(null));
        this.blockEntity.markDataDirty();
    }

    @LuaFunction(mainThread=true)
    public final int getLightLevel() {
        return this.blockEntity.getData().getLightLevel();
    }

    @LuaFunction(mainThread=true)
    public final void setLightLevel(int lightLevel) {
        this.blockEntity.getData().setLightLevel(lightLevel);
        this.blockEntity.markDataDirty();
    }

    @LuaFunction(mainThread=true)
    public final int getRedstoneLevel() {
        return this.blockEntity.getData().getRedstoneLevel();
    }

    @LuaFunction(mainThread=true)
    public final void setRedstoneLevel(int redstoneLevel) {
        this.blockEntity.getData().setRedstoneLevel(redstoneLevel);
        this.blockEntity.markDataDirty();
    }

    @LuaFunction(mainThread=true)
    public final boolean getButtonMode() {
        return this.blockEntity.getData().isButton();
    }

    @LuaFunction(mainThread=true)
    public final void setButtonMode(boolean isButton) {
        this.blockEntity.getData().setButton(isButton);
        this.blockEntity.markDataDirty();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult isCollidable() {
        PrintData data = this.blockEntity.getData();
        return MethodResult.of((Object[])new Object[]{data.isCollideWhenOff(), data.isCollideWhenOn()});
    }

    @LuaFunction(mainThread=true)
    public final void setCollidable(boolean collideWhenOff, boolean collideWhenOn) {
        PrintData data = this.blockEntity.getData();
        data.setCollideWhenOff(collideWhenOff);
        data.setCollideWhenOn(collideWhenOn);
        this.blockEntity.markDataDirty();
    }

    @LuaFunction(mainThread=true)
    public final boolean hasOrientation() {
        return this.blockEntity.getData().hasOrientation();
    }

    @LuaFunction(mainThread=true)
    public final void setOrientation(boolean hasOrientation) {
        this.blockEntity.getData().setHasOrientation(hasOrientation);
        this.blockEntity.markDataDirty();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getShapeCount() {
        PrintData data = this.blockEntity.getData();
        return MethodResult.of((Object[])new Object[]{data.getShapesOff().size(), data.getShapesOn().size()});
    }

    @LuaFunction
    public final int getMaxShapeCount() {
        return Config.printerMaxShapes;
    }

    @LuaFunction(mainThread=true)
    public final void addShape(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Optional<String> texture, Optional<Boolean> state, Optional<Integer> tint) throws LuaException {
        PrintData data = this.blockEntity.getData();
        if (data.getShapesOff().size() >= Config.printerMaxShapes || data.getShapesOn().size() >= Config.printerMaxShapes) {
            throw new LuaException("Too many shapes");
        }
        AABB box = new AABB((double)(minX = PrinterPeripheral.clamp(minX, 0, 16)), (double)(minY = PrinterPeripheral.clamp(minY, 0, 16)), (double)(minZ = PrinterPeripheral.clamp(minZ, 0, 16)), (double)(maxX = PrinterPeripheral.clamp(maxX, 0, 16)), (double)(maxY = PrinterPeripheral.clamp(maxY, 0, 16)), (double)(maxZ = PrinterPeripheral.clamp(maxZ, 0, 16)));
        if (box.m_82362_() <= 0.0 || box.m_82376_() <= 0.0 || box.m_82385_() <= 0.0) {
            throw new LuaException("Empty block");
        }
        ResourceLocation textureId = null;
        if (texture.isPresent() && !texture.get().isEmpty()) {
            String texString = texture.get();
            if (texString.length() > 64) {
                texString = texString.substring(0, 64);
            }
            if ((textureId = ResourceLocation.m_135820_((String)texString)) == null) {
                throw new LuaException("Invalid texture: " + texString);
            }
        }
        Integer fixedTint = tint.map(t -> t & 0xFFFFFF).orElse(null);
        boolean isOn = state.orElse(false);
        Shape shape = new Shape(box, textureId, fixedTint);
        if (isOn) {
            data.getShapesOn().add(shape);
        } else {
            data.getShapesOff().add(shape);
        }
        this.blockEntity.markDataDirty();
    }

    @LuaFunction(mainThread=true)
    public final boolean commit(int count) throws LuaException {
        if (!this.blockEntity.canPrint()) {
            throw new LuaException("Model is invalid");
        }
        int clampedCount = Math.max(0, count);
        this.blockEntity.setPrintCount(clampedCount);
        boolean shouldPrint = clampedCount > 0;
        this.blockEntity.setPrinting(shouldPrint);
        return shouldPrint;
    }

    @LuaFunction(mainThread=true)
    public final void stop() {
        this.blockEntity.setPrintCount(0);
        this.blockEntity.setPrinting(false);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult status() {
        return this.blockEntity.getStatus();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getChameliumLevel() {
        return MethodResult.of((Object[])new Object[]{this.blockEntity.getChamelium(), 256000});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getInkLevel() {
        return MethodResult.of((Object[])new Object[]{this.blockEntity.getInk(), 100000});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getSeatPos() {
        Vec3 seatPos = this.blockEntity.data.getSeatPos();
        if (seatPos != null) {
            return MethodResult.of((Object[])new Object[]{seatPos.f_82479_, seatPos.f_82480_, seatPos.f_82481_});
        }
        return MethodResult.of((Object[])new Object[]{null, null, null});
    }

    @LuaFunction(mainThread=true)
    public final void setSeatPos(Optional<Double> x, Optional<Double> y, Optional<Double> z) throws LuaException {
        Vec3 pos;
        if (x.isPresent() && y.isPresent() && z.isPresent()) {
            pos = new Vec3(x.orElse(0.5).doubleValue(), y.orElse(0.5).doubleValue(), z.orElse(0.5).doubleValue());
            if (!PrintData.isValidSeatPos(pos)) {
                throw new LuaException("Seat position must be between 0.1 and 0.9 on all axes");
            }
        } else {
            pos = null;
        }
        this.blockEntity.data.setSeatPos(pos);
        this.blockEntity.dataUpdated();
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.blockEntity.attachComputer(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.blockEntity.detachComputer(computer);
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

