/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.network;

import java.util.function.Supplier;
import kalrog.cc_printers_plus.block.entity.PrinterBlockEntity;
import kalrog.cc_printers_plus.data.PrintData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PrinterStartPrintPacket {
    private final BlockPos pos;
    private final PrintData data;
    private final int count;

    public PrinterStartPrintPacket(BlockPos pos, PrintData data, int count) {
        this.pos = pos;
        this.data = data;
        this.count = count;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(this.data.toNbt());
        buf.writeInt(this.count);
    }

    public static PrinterStartPrintPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        CompoundTag tag = buf.m_130260_();
        PrintData data = tag != null ? PrintData.fromNbt(tag) : new PrintData();
        int count = buf.readInt();
        return new PrinterStartPrintPacket(pos, data, count);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity be;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && player.m_9236_() != null && (be = player.m_9236_().m_7702_(this.pos)) instanceof PrinterBlockEntity) {
                PrinterBlockEntity printer = (PrinterBlockEntity)be;
                if (player.m_20183_().m_123331_((Vec3i)this.pos) > 4096.0) {
                    return;
                }
                printer.data = this.data;
                printer.printCount = this.count;
                printer.printing = true;
                printer.m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

