/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.network;

import java.util.function.Supplier;
import kalrog.cc_printers_plus.block.entity.PrinterBlockEntity;
import kalrog.cc_printers_plus.data.PrintData;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PrinterDataPacket {
    private final BlockPos pos;
    private final PrintData data;

    public PrinterDataPacket(BlockPos pos, PrintData data) {
        this.pos = pos;
        this.data = data;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(this.data.toNbt());
    }

    public static PrinterDataPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        CompoundTag tag = buf.m_130260_();
        PrintData data = tag != null ? PrintData.fromNbt(tag) : new PrintData();
        return new PrinterDataPacket(pos, data);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity be;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ != null && (be = minecraft.f_91073_.m_7702_(this.pos)) instanceof PrinterBlockEntity) {
                PrinterBlockEntity printer = (PrinterBlockEntity)be;
                printer.data = this.data;
                printer.previewData = this.data;
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

