/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.menu;

import kalrog.cc_printers_plus.Registration;
import kalrog.cc_printers_plus.block.entity.PrinterBlockEntity;
import kalrog.cc_printers_plus.menu.ValidatingSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PrinterMenu
extends AbstractContainerMenu {
    private final PrinterBlockEntity blockEntity;
    private final ContainerData data;

    public PrinterMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, null, new SimpleContainerData(6));
    }

    public PrinterMenu(int containerId, Inventory playerInventory, PrinterBlockEntity blockEntity, ContainerData data) {
        super((MenuType)Registration.PRINTER_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.data = data;
        SimpleContainer dummyContainer = new SimpleContainer(3);
        PrinterBlockEntity container = blockEntity != null ? blockEntity : dummyContainer;
        this.m_38897_(new ValidatingSlot(container, 0, 17, 17, stack -> stack.m_150930_((Item)Registration.CHAMELIUM_ITEM.get()) || stack.m_150930_((Item)Registration.PRINT_ITEM.get())));
        this.m_38897_(new ValidatingSlot(container, 1, 17, 53, stack -> stack.m_150930_((Item)Registration.INK_CARTRIDGE.get())));
        this.m_38897_(new ValidatingSlot(container, 2, 139, 35, stack -> false));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
        this.m_38884_(data);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            result = stackInSlot.m_41777_();
            if (index < 3 ? !this.m_38903_(stackInSlot, 3, 39, true) : (stackInSlot.m_150930_((Item)Registration.CHAMELIUM_ITEM.get()) ? !this.m_38903_(stackInSlot, 0, 1, false) : (stackInSlot.m_150930_((Item)Registration.INK_CARTRIDGE.get()) ? !this.m_38903_(stackInSlot, 1, 2, false) : (index < 30 ? !this.m_38903_(stackInSlot, 30, 39, false) : !this.m_38903_(stackInSlot, 3, 30, false))))) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return result;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity == null || this.blockEntity.m_6542_(player);
    }

    public int getChamelium() {
        return this.data.m_6413_(0) & 0xFFFF | (this.data.m_6413_(1) & 0xFFFF) << 16;
    }

    public int getInk() {
        return this.data.m_6413_(2) & 0xFFFF | (this.data.m_6413_(3) & 0xFFFF) << 16;
    }

    public int getPrintProgress() {
        return this.data.m_6413_(4);
    }

    public int getMaxPrintProgress() {
        return this.data.m_6413_(5);
    }

    private static class SimpleContainerData
    implements ContainerData {
        private final int[] data;

        public SimpleContainerData(int size) {
            this.data = new int[size];
        }

        public int m_6413_(int index) {
            return this.data[index];
        }

        public void m_8050_(int index, int value) {
            this.data[index] = value;
        }

        public int m_6499_() {
            return this.data.length;
        }
    }
}

