/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import kalrog.cc_printers_plus.Registration;
import kalrog.cc_printers_plus.client.PrintItemRenderer;
import kalrog.cc_printers_plus.data.PrintData;
import kalrog.cc_printers_plus.util.NbtExtensions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class PrintItem
extends BlockItem {
    public PrintItem(Item.Properties properties) {
        super((Block)Registration.PRINT_BLOCK.get(), properties);
    }

    public static ItemStack create(PrintData data) {
        ItemStack stack = new ItemStack((ItemLike)Registration.PRINT_ITEM.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("print", (Tag)data.toNbt());
        stack.m_41751_(tag);
        return stack;
    }

    @Nullable
    public static PrintData getPrintData(ItemStack stack) {
        if (!stack.m_150930_((Item)Registration.PRINT_ITEM.get())) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        CompoundTag printTag = NbtExtensions.optCompound(tag, "print");
        if (printTag == null) {
            return null;
        }
        return PrintData.fromNbt(printTag);
    }

    public Component m_7626_(ItemStack stack) {
        PrintData data = PrintItem.getPrintData(stack);
        if (data != null && data.getLabelText() != null) {
            return data.getLabelText();
        }
        return super.m_7626_(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private PrintItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PrintItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_());
                }
                return this.renderer;
            }
        });
    }
}

