/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.data;

import javax.annotation.Nullable;
import kalrog.cc_printers_plus.Registration;
import kalrog.cc_printers_plus.data.ShapesCollection;
import kalrog.cc_printers_plus.util.NbtExtensions;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PrintData {
    public static final int MAX_LABEL_LENGTH = 48;
    public static final int MAX_TOOLTIP_LENGTH = 256;
    @Nullable
    private String label;
    @Nullable
    private Component labelText;
    @Nullable
    private String tooltip;
    private boolean isButton = false;
    private boolean collideWhenOn = true;
    private boolean collideWhenOff = true;
    private boolean lightWhenOn = true;
    private boolean lightWhenOff = true;
    private int lightLevel = 0;
    private int redstoneLevel = 0;
    private boolean isBeaconBlock = false;
    private boolean isQuiet = false;
    private boolean hasOrientation = false;
    private final ShapesCollection shapesOff = new ShapesCollection();
    private final ShapesCollection shapesOn = new ShapesCollection();
    @Nullable
    private Vec3 seatPos = null;

    public PrintData() {
        this(null, null);
    }

    public PrintData(@Nullable String label, @Nullable String tooltip) {
        this.setLabel(label);
        this.tooltip = PrintData.sanitizeTooltip(tooltip);
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable String label) {
        this.label = PrintData.sanitizeLabel(label);
        this.labelText = this.label != null ? Component.m_237113_((String)this.label) : null;
    }

    @Nullable
    public Component getLabelText() {
        return this.labelText;
    }

    @Nullable
    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(@Nullable String tooltip) {
        this.tooltip = PrintData.sanitizeTooltip(tooltip);
    }

    public ShapesCollection getShapesOff() {
        return this.shapesOff;
    }

    public ShapesCollection getShapesOn() {
        return this.shapesOn;
    }

    public boolean isButton() {
        return this.isButton;
    }

    public void setButton(boolean button) {
        this.isButton = button;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = Math.max(0, Math.min(15, lightLevel));
    }

    public int getRedstoneLevel() {
        return this.redstoneLevel;
    }

    public void setRedstoneLevel(int redstoneLevel) {
        this.redstoneLevel = Math.max(0, Math.min(15, redstoneLevel));
    }

    public boolean isBeaconBlock() {
        return this.isBeaconBlock;
    }

    public void setBeaconBlock(boolean beaconBlock) {
        this.isBeaconBlock = beaconBlock;
    }

    public boolean isQuiet() {
        return this.isQuiet;
    }

    public void setQuiet(boolean quiet) {
        this.isQuiet = quiet;
    }

    public boolean hasOrientation() {
        return this.hasOrientation;
    }

    public void setHasOrientation(boolean hasOrientation) {
        this.hasOrientation = hasOrientation;
    }

    public boolean isCollideWhenOn() {
        return this.collideWhenOn;
    }

    public void setCollideWhenOn(boolean collideWhenOn) {
        this.collideWhenOn = collideWhenOn;
    }

    public boolean isCollideWhenOff() {
        return this.collideWhenOff;
    }

    public void setCollideWhenOff(boolean collideWhenOff) {
        this.collideWhenOff = collideWhenOff;
    }

    public boolean isLightWhenOn() {
        return this.lightWhenOn;
    }

    public void setLightWhenOn(boolean lightWhenOn) {
        this.lightWhenOn = lightWhenOn;
    }

    public boolean isLightWhenOff() {
        return this.lightWhenOff;
    }

    public void setLightWhenOff(boolean lightWhenOff) {
        this.lightWhenOff = lightWhenOff;
    }

    @Nullable
    public Vec3 getSeatPos() {
        return this.seatPos;
    }

    public void setSeatPos(@Nullable Vec3 seatPos) {
        if (seatPos != null && !PrintData.isValidSeatPos(seatPos)) {
            throw new IllegalArgumentException("Seat position must be between 0.1 and 0.9 on all axes");
        }
        this.seatPos = seatPos;
    }

    public Pair<Integer, Integer> computeCosts() {
        double totalVolume = this.shapesOff.getTotalVolume() + this.shapesOn.getTotalVolume();
        double totalSurface = this.shapesOff.getTotalSurfaceArea() + this.shapesOn.getTotalSurfaceArea();
        if (totalVolume <= 0.0) {
            return null;
        }
        int redstoneCost = this.redstoneLevel >= 1 && this.redstoneLevel <= 14 ? 10 : 0;
        int noclipCost = !this.collideWhenOff || !this.collideWhenOn ? 2 : 1;
        int chamelium = (int)((Math.max(totalVolume / 2.0, 1.0) + (double)redstoneCost) * (double)noclipCost);
        int ink = (int)Math.max(totalSurface / 6.0, 1.0);
        return new Pair<Integer, Integer>(chamelium, ink);
    }

    public boolean isEmpty() {
        return this.shapesOff.isEmpty() && this.shapesOn.isEmpty();
    }

    public ItemStack toItemStack() {
        ItemStack stack = new ItemStack((ItemLike)Registration.PRINT_ITEM.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("print", (Tag)this.toNbt());
        stack.m_41751_(tag);
        return stack;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        NbtExtensions.putOptString(nbt, "label", PrintData.sanitizeLabel(this.label));
        NbtExtensions.putOptString(nbt, "tooltip", PrintData.sanitizeTooltip(this.tooltip));
        nbt.m_128379_("isButton", this.isButton);
        nbt.m_128379_("collideWhenOn", this.collideWhenOn);
        nbt.m_128379_("collideWhenOff", this.collideWhenOff);
        nbt.m_128379_("lightWhenOn2", this.lightWhenOn);
        nbt.m_128379_("lightWhenOff2", this.lightWhenOff);
        nbt.m_128405_("lightLevel", this.lightLevel);
        nbt.m_128405_("redstoneLevel", this.redstoneLevel);
        nbt.m_128379_("isBeaconBlock", this.isBeaconBlock);
        nbt.m_128379_("isQuiet", this.isQuiet);
        nbt.m_128379_("hasOrientation", this.hasOrientation);
        nbt.m_128365_("shapesOff", (Tag)this.shapesOff.toNbt());
        nbt.m_128365_("shapesOn", (Tag)this.shapesOn.toNbt());
        if (this.seatPos != null) {
            nbt.m_128347_("seatX", this.seatPos.f_82479_);
            nbt.m_128347_("seatY", this.seatPos.f_82480_);
            nbt.m_128347_("seatZ", this.seatPos.f_82481_);
        }
        return nbt;
    }

    public static PrintData fromNbt(CompoundTag nbt) {
        PrintData data = new PrintData(NbtExtensions.optString(nbt, "label"), NbtExtensions.optString(nbt, "tooltip"));
        data.isButton = nbt.m_128471_("isButton");
        data.collideWhenOn = nbt.m_128471_("collideWhenOn");
        data.collideWhenOff = nbt.m_128471_("collideWhenOff");
        data.lightWhenOn = NbtExtensions.optBoolean(nbt, "lightWhenOn2", true);
        data.lightWhenOff = NbtExtensions.optBoolean(nbt, "lightWhenOff2", true);
        data.lightLevel = nbt.m_128451_("lightLevel");
        data.redstoneLevel = nbt.m_128451_("redstoneLevel");
        data.isBeaconBlock = nbt.m_128471_("isBeaconBlock");
        data.isQuiet = nbt.m_128471_("isQuiet");
        data.hasOrientation = nbt.m_128471_("hasOrientation");
        if (nbt.m_128441_("shapesOff")) {
            ListTag shapesOffList = nbt.m_128437_("shapesOff", 10);
            data.shapesOff.addAll(ShapesCollection.fromNbt(shapesOffList));
        }
        if (nbt.m_128441_("shapesOn")) {
            ListTag shapesOnList = nbt.m_128437_("shapesOn", 10);
            data.shapesOn.addAll(ShapesCollection.fromNbt(shapesOnList));
        }
        if (nbt.m_128441_("seatX") && nbt.m_128441_("seatY") && nbt.m_128441_("seatZ")) {
            Vec3 seatPos;
            double x = nbt.m_128459_("seatX");
            double y = nbt.m_128459_("seatY");
            double z = nbt.m_128459_("seatZ");
            if (Double.isFinite(x) && Double.isFinite(y) && Double.isFinite(z) && PrintData.isValidSeatPos(seatPos = new Vec3(x, y, z))) {
                data.seatPos = seatPos;
            }
        }
        return data;
    }

    @Nullable
    private static String sanitizeLabel(@Nullable String s) {
        if (s == null || s.isEmpty() || s.length() > 48) {
            return null;
        }
        return PrintData.stripInvalidChars(s, false);
    }

    @Nullable
    private static String sanitizeTooltip(@Nullable String s) {
        if (s == null || s.isEmpty() || s.length() > 256) {
            return null;
        }
        return PrintData.stripInvalidChars(s, true);
    }

    private static String stripInvalidChars(String s, boolean allowNewlines) {
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if ((c < ' ' || c >= '\u007f') && c != '\u00a7' && c != '\ue000' && (!allowNewlines || c != '\n')) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isValidSeatPos(Vec3 pos) {
        return pos.f_82479_ >= 0.1 && pos.f_82479_ <= 0.9 && pos.f_82480_ >= 0.1 && pos.f_82480_ <= 0.9 && pos.f_82481_ >= 0.1 && pos.f_82481_ <= 0.9;
    }

    public VoxelShape getVoxelShape(Direction facing, boolean on) {
        ShapesCollection shapes = on ? this.shapesOn : this.shapesOff;
        return shapes.toVoxelShape(facing);
    }

    public static class Pair<A, B> {
        public final A first;
        public final B second;

        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }
    }
}

