/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.client.model;

import java.util.ArrayList;
import java.util.List;
import kalrog.cc_printers_plus.data.Shape;
import kalrog.cc_printers_plus.data.ShapesCollection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintQuadBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CCPrintersPlus/PrintQuadBuilder");
    private static final Vector3f[] NORMALS = new Vector3f[]{new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};

    public List<BakedQuad> buildQuads(ShapesCollection shapes, Direction facing) {
        LOGGER.info("Building quads " + shapes.hashCode() + " with facing " + String.valueOf(facing));
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(quad -> quads.add((BakedQuad)quad));
        for (Shape shape : shapes) {
            if (shape.getTexture() == null) continue;
            this.buildShape(builder, shape, facing);
        }
        return quads;
    }

    private void buildShape(QuadBakingVertexConsumer builder, Shape shape, Direction facing) {
        AABB bounds = this.rotateBounds(shape.getBounds(), facing);
        ResourceLocation texture = shape.getTexture();
        Integer tint = shape.getTint();
        TextureAtlasSprite sprite = this.getSprite(texture);
        int color = (tint != null ? tint : 0xFFFFFF) & 0xFFFFFF | 0xFF000000;
        for (Direction dir : Direction.values()) {
            this.buildFace(builder, bounds, dir, sprite, color);
        }
    }

    private AABB rotateBounds(AABB bounds, Direction facing) {
        double newZ2;
        double newX2;
        double newZ1;
        double newX1;
        if (facing == Direction.NORTH) {
            return bounds;
        }
        double x1 = bounds.f_82288_;
        double y1 = bounds.f_82289_;
        double z1 = bounds.f_82290_;
        double x2 = bounds.f_82291_;
        double y2 = bounds.f_82292_;
        double z2 = bounds.f_82293_;
        x1 -= 8.0;
        z1 -= 8.0;
        x2 -= 8.0;
        z2 -= 8.0;
        switch (facing) {
            case SOUTH: {
                newX1 = -x2;
                newZ1 = -z2;
                newX2 = -x1;
                newZ2 = -z1;
                break;
            }
            case WEST: {
                newX1 = z1;
                newZ1 = -x2;
                newX2 = z2;
                newZ2 = -x1;
                break;
            }
            case EAST: {
                newX1 = -z2;
                newZ1 = x1;
                newX2 = -z1;
                newZ2 = x2;
                break;
            }
            default: {
                return bounds;
            }
        }
        return new AABB(Math.min(newX1 += 8.0, newX2 += 8.0), y1, Math.min(newZ1 += 8.0, newZ2 += 8.0), Math.max(newX1, newX2), y2, Math.max(newZ1, newZ2));
    }

    private void buildFace(QuadBakingVertexConsumer builder, AABB bounds, Direction face, TextureAtlasSprite sprite, int color) {
        float minX = (float)(bounds.f_82288_ / 16.0);
        float minY = (float)(bounds.f_82289_ / 16.0);
        float minZ = (float)(bounds.f_82290_ / 16.0);
        float maxX = (float)(bounds.f_82291_ / 16.0);
        float maxY = (float)(bounds.f_82292_ / 16.0);
        float maxZ = (float)(bounds.f_82293_ / 16.0);
        builder.setSprite(sprite);
        builder.setDirection(face);
        builder.setTintIndex(-1);
        builder.setShade(true);
        Vector3f normal = NORMALS[face.ordinal()];
        switch (face) {
            case DOWN: {
                this.addVertex(builder, minX, minY, minZ, sprite, minX, minZ, color, normal);
                this.addVertex(builder, maxX, minY, minZ, sprite, maxX, minZ, color, normal);
                this.addVertex(builder, maxX, minY, maxZ, sprite, maxX, maxZ, color, normal);
                this.addVertex(builder, minX, minY, maxZ, sprite, minX, maxZ, color, normal);
                break;
            }
            case UP: {
                this.addVertex(builder, minX, maxY, minZ, sprite, minX, minZ, color, normal);
                this.addVertex(builder, minX, maxY, maxZ, sprite, minX, maxZ, color, normal);
                this.addVertex(builder, maxX, maxY, maxZ, sprite, maxX, maxZ, color, normal);
                this.addVertex(builder, maxX, maxY, minZ, sprite, maxX, minZ, color, normal);
                break;
            }
            case NORTH: {
                this.addVertex(builder, minX, minY, minZ, sprite, minX, 1.0f - minY, color, normal);
                this.addVertex(builder, minX, maxY, minZ, sprite, minX, 1.0f - maxY, color, normal);
                this.addVertex(builder, maxX, maxY, minZ, sprite, maxX, 1.0f - maxY, color, normal);
                this.addVertex(builder, maxX, minY, minZ, sprite, maxX, 1.0f - minY, color, normal);
                break;
            }
            case SOUTH: {
                this.addVertex(builder, minX, minY, maxZ, sprite, 1.0f - minX, 1.0f - minY, color, normal);
                this.addVertex(builder, maxX, minY, maxZ, sprite, 1.0f - maxX, 1.0f - minY, color, normal);
                this.addVertex(builder, maxX, maxY, maxZ, sprite, 1.0f - maxX, 1.0f - maxY, color, normal);
                this.addVertex(builder, minX, maxY, maxZ, sprite, 1.0f - minX, 1.0f - maxY, color, normal);
                break;
            }
            case WEST: {
                this.addVertex(builder, minX, minY, minZ, sprite, minZ, 1.0f - minY, color, normal);
                this.addVertex(builder, minX, minY, maxZ, sprite, maxZ, 1.0f - minY, color, normal);
                this.addVertex(builder, minX, maxY, maxZ, sprite, maxZ, 1.0f - maxY, color, normal);
                this.addVertex(builder, minX, maxY, minZ, sprite, minZ, 1.0f - maxY, color, normal);
                break;
            }
            case EAST: {
                this.addVertex(builder, maxX, minY, minZ, sprite, 1.0f - minZ, 1.0f - minY, color, normal);
                this.addVertex(builder, maxX, maxY, minZ, sprite, 1.0f - minZ, 1.0f - maxY, color, normal);
                this.addVertex(builder, maxX, maxY, maxZ, sprite, 1.0f - maxZ, 1.0f - maxY, color, normal);
                this.addVertex(builder, maxX, minY, maxZ, sprite, 1.0f - maxZ, 1.0f - minY, color, normal);
            }
        }
    }

    private void addVertex(QuadBakingVertexConsumer builder, float x, float y, float z, TextureAtlasSprite sprite, float u, float v, int color, Vector3f normal) {
        float spriteU = sprite.m_118367_((double)(u * 16.0f));
        float spriteV = sprite.m_118393_((double)(v * 16.0f));
        builder.m_5483_((double)x, (double)y, (double)z).m_193479_(color).m_7421_(spriteU, spriteV).m_5601_(normal.x(), normal.y(), normal.z()).m_5752_();
    }

    private TextureAtlasSprite getSprite(ResourceLocation texture) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
    }
}

