/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.client.model;

import java.util.Collections;
import java.util.List;
import java.util.stream.StreamSupport;
import kalrog.cc_printers_plus.client.model.PrintItemOverrides;
import kalrog.cc_printers_plus.client.model.PrintQuadBuilder;
import kalrog.cc_printers_plus.data.PrintData;
import kalrog.cc_printers_plus.data.ShapesCollection;
import kalrog.cc_printers_plus.data.ShapesFacing;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrintBakedModel
implements BakedModel {
    public static final ModelProperty<ShapesCollection> SHAPES_PROPERTY = new ModelProperty();
    public static final ModelProperty<Direction> FACING_PROPERTY = new ModelProperty();
    private final TextureAtlasSprite particleSprite;
    private final PrintItemOverrides itemOverrides;
    private static final ThreadLocal<PrintQuadBuilder> QUAD_BUILDER = ThreadLocal.withInitial(PrintQuadBuilder::new);
    private static final Cache<ShapesFacing, List<BakedQuad>> blockMeshCache = new Cache2kBuilder<ShapesFacing, List<BakedQuad>>(){}.entryCapacity(1000L).build();
    private static final Cache<ShapesCollection, List<BakedQuad>> itemMeshCache = new Cache2kBuilder<ShapesCollection, List<BakedQuad>>(){}.entryCapacity(1000L).build();
    private static final Cache<ItemStack, PrintData> itemDataCache = new Cache2kBuilder<ItemStack, PrintData>(){}.entryCapacity(10000L).build();

    public PrintBakedModel(TextureAtlasSprite particleSprite) {
        this.particleSprite = particleSprite;
        this.itemOverrides = new PrintItemOverrides(this);
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource random) {
        return Collections.emptyList();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource random, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (side != null) {
            return Collections.emptyList();
        }
        ShapesCollection shapes = (ShapesCollection)extraData.get(SHAPES_PROPERTY);
        Direction facing = (Direction)extraData.get(FACING_PROPERTY);
        if (shapes == null || shapes.isEmpty()) {
            return Collections.emptyList();
        }
        Direction finalFacing = facing != null ? facing : Direction.NORTH;
        ShapesFacing key = new ShapesFacing(shapes, finalFacing);
        return (List)blockMeshCache.computeIfAbsent((Object)key, k -> {
            PrintQuadBuilder builder = QUAD_BUILDER.get();
            return builder.buildQuads(shapes, finalFacing);
        });
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        return modelData;
    }

    public List<BakedQuad> getItemQuads(ItemStack stack) {
        if (!stack.m_41782_()) {
            return Collections.emptyList();
        }
        try {
            PrintData printData = (PrintData)itemDataCache.computeIfAbsent((Object)stack, s -> {
                CompoundTag tag = s.m_41783_();
                if (tag != null && tag.m_128441_("printData")) {
                    return PrintData.fromNbt(tag.m_128469_("printData"));
                }
                throw new IllegalArgumentException("No print data");
            });
            ShapesCollection shapes = printData.getShapesOff();
            if (shapes.isEmpty()) {
                return Collections.emptyList();
            }
            return (List)itemMeshCache.computeIfAbsent((Object)shapes, s -> {
                PrintQuadBuilder builder = QUAD_BUILDER.get();
                return builder.buildQuads((ShapesCollection)s, Direction.SOUTH);
            });
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.particleSprite;
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return this.itemOverrides;
    }

    public static void clearCaches() {
        blockMeshCache.clear();
        itemMeshCache.clear();
        itemDataCache.clear();
    }

    public static String getCacheStats() {
        return String.format("PrintModel Caches - Blocks: %d, Items: %d, ItemData: %d", blockMeshCache.keys().iterator().hasNext() ? StreamSupport.stream(blockMeshCache.keys().spliterator(), false).count() : 0L, itemMeshCache.keys().iterator().hasNext() ? StreamSupport.stream(itemMeshCache.keys().spliterator(), false).count() : 0L, itemDataCache.keys().iterator().hasNext() ? StreamSupport.stream(itemDataCache.keys().spliterator(), false).count() : 0L);
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return Collections.singletonList(RenderType.m_110466_());
    }
}

