/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.client;

import kalrog.cc_printers_plus.Registration;
import kalrog.cc_printers_plus.client.PrinterRenderer;
import kalrog.cc_printers_plus.client.SeatEntityRenderer;
import kalrog.cc_printers_plus.client.model.PrintBakedModel;
import kalrog.cc_printers_plus.client.model.PrintGeometryLoader;
import kalrog.cc_printers_plus.client.screen.PrinterScreen;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="cc_printers_plus", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CCPrintersPlusClient {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CCPrintersPlus/Client");

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("CC Printers Plus client initializing");
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)Registration.PRINTER_MENU.get()), PrinterScreen::new));
        LOGGER.info("CC Printers Plus client initialization complete");
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Registration.PRINTER_BLOCK_ENTITY.get(), PrinterRenderer::new);
        event.registerEntityRenderer((EntityType)Registration.SEAT_ENTITY.get(), SeatEntityRenderer::new);
    }

    @SubscribeEvent
    public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
        LOGGER.info("Registering print geometry loader");
        event.register("print", (IGeometryLoader)PrintGeometryLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void onModelBakingCompleted(ModelEvent.BakingCompleted event) {
        LOGGER.info("Model baking completed - Cache stats: {}", (Object)PrintBakedModel.getCacheStats());
    }
}

