/*
 * Decompiled with CFR 0.152.
 */
package kalrog.cc_printers_plus.block;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import kalrog.cc_printers_plus.Registration;
import kalrog.cc_printers_plus.block.entity.PrintBlockEntity;
import kalrog.cc_printers_plus.data.PrintData;
import kalrog.cc_printers_plus.entity.SeatEntity;
import kalrog.cc_printers_plus.item.PrintItem;
import kalrog.cc_printers_plus.util.BaseBlockWithEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PrintBlock
extends BaseBlockWithEntity {
    public static final IntegerProperty LUMINANCE = IntegerProperty.m_61631_((String)"luminance", (int)0, (int)15);
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final int TOGGLE_TICKS = 20;

    public PrintBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LUMINANCE, (Comparable)Integer.valueOf(0))).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PrintBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LUMINANCE, ON, POWERED, FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        PrintData data = PrintItem.getPrintData(stack);
        BlockState state = this.m_49966_();
        if (data != null && data.hasOrientation()) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return state;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean isPowered;
        PrintBlockEntity printEntity;
        PrintData data;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof PrintBlockEntity && (data = (printEntity = (PrintBlockEntity)blockEntity).getPrintData()) != null && printEntity.getRedstoneOutput() == 0 && printEntity.canTurnOn() && (isPowered = level.m_276867_(pos)) != (Boolean)state.m_61143_((Property)POWERED)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 2);
            printEntity.updateRedstoneInput();
        }
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrintBlockEntity) {
            PrintBlockEntity printEntity = (PrintBlockEntity)blockEntity;
            return printEntity.getRedstoneOutput();
        }
        return 0;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LUMINANCE);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        PrintBlockEntity printEntity;
        PrintData data;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrintBlockEntity && (data = (printEntity = (PrintBlockEntity)blockEntity).getPrintData()) != null && !data.isEmpty()) {
            return data.toItemStack();
        }
        return new ItemStack((ItemLike)Registration.PRINT_ITEM.get());
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        PrintBlockEntity printEntity;
        PrintData data;
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof PrintBlockEntity && (data = (printEntity = (PrintBlockEntity)blockEntity).getPrintData()) != null && !data.isEmpty()) {
            return Collections.singletonList(data.toItemStack());
        }
        return Collections.singletonList(new ItemStack((ItemLike)Registration.PRINT_ITEM.get()));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        PrintData data = PrintItem.getPrintData(stack);
        if (data != null && (blockEntity = level.m_7702_(pos)) instanceof PrintBlockEntity) {
            PrintBlockEntity printEntity = (PrintBlockEntity)blockEntity;
            printEntity.setPrintData(data);
            boolean hasLight = data.isLightWhenOff();
            int lightLevel = hasLight ? data.getLightLevel() : 0;
            BlockState newState = (BlockState)state.m_61124_((Property)LUMINANCE, (Comparable)Integer.valueOf(lightLevel));
            if (newState != state) {
                level.m_7731_(pos, newState, 3);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrintBlockEntity) {
            PrintBlockEntity printEntity = (PrintBlockEntity)blockEntity;
            PrintData data = printEntity.getPrintData();
            if (data != null && printEntity.canTurnOn()) {
                if (!level.f_46443_) {
                    printEntity.toggle();
                }
                return InteractionResult.SUCCESS;
            }
            if (data != null && data.getSeatPos() != null) {
                if (player.m_20159_()) {
                    return InteractionResult.PASS;
                }
                if (!level.f_46443_) {
                    Vec3 seatOffset = data.getSeatPos();
                    boolean seatExists = level.m_45933_(null, new AABB(pos).m_82400_(1.0)).stream().anyMatch(e -> e instanceof SeatEntity && e.m_20183_().equals((Object)pos));
                    if (seatExists) {
                        return InteractionResult.PASS;
                    }
                    SeatEntity seat = new SeatEntity(level, pos, seatOffset);
                    level.m_7967_((Entity)seat);
                    player.m_20329_((Entity)seat);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        PrintBlockEntity printEntity;
        PrintData data;
        if (level.f_46443_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrintBlockEntity && (data = (printEntity = (PrintBlockEntity)blockEntity).getPrintData()) != null && data.isButton() && ((Boolean)state.m_61143_((Property)ON)).booleanValue()) {
            printEntity.toggle();
        }
    }

    private VoxelShape getVoxelShape(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrintBlockEntity) {
            PrintBlockEntity printEntity = (PrintBlockEntity)blockEntity;
            PrintData data = printEntity.getPrintData();
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            boolean on = (Boolean)state.m_61143_((Property)ON);
            if (data != null) {
                return data.getVoxelShape(facing, on);
            }
        }
        return Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        PrintBlockEntity printEntity;
        VoxelShape shape = this.getVoxelShape(state, level, pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PrintBlockEntity && !(printEntity = (PrintBlockEntity)blockEntity).hasCollision()) {
            return Shapes.m_83040_();
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext p_60558_) {
        return this.getVoxelShape(state, level, pos);
    }
}

