/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.config.StructureToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererStructures
extends OverlayRendererBase {
    public static final OverlayRendererStructures INSTANCE = new OverlayRendererStructures();

    private OverlayRendererStructures() {
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return false;
        }
        for (StructureType type : StructureType.VALUES) {
            if (!type.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        int hysteresis = 16;
        return DataStorage.getInstance().structureRendererNeedsUpdate() || Math.abs(entity.m_20185_() - (double)this.lastUpdatePos.m_123341_()) > (double)hysteresis || Math.abs(entity.m_20186_() - (double)this.lastUpdatePos.m_123342_()) > (double)hysteresis || Math.abs(entity.m_20189_() - (double)this.lastUpdatePos.m_123343_()) > (double)hysteresis;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        int maxRange = ((Integer)mc.f_91066_.m_231984_().m_231551_() + 4) * 16;
        List<StructureData> data = this.getStructuresToRender(this.lastUpdatePos, maxRange);
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        BUFFER_2.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
        if (!data.isEmpty()) {
            this.renderStructureBoxes(data, cameraPos);
        }
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
    }

    private void renderStructureBoxes(List<StructureData> wrappedData, Vec3 cameraPos) {
        for (StructureData data : wrappedData) {
            StructureToggle toggle = data.getStructureType().getToggle();
            Color4f mainColor = toggle.getColorMain().getColor();
            Color4f componentColor = toggle.getColorComponents().getColor();
            this.renderStructure(data, mainColor, componentColor, cameraPos);
        }
    }

    private void renderStructure(StructureData structure, Color4f mainColor, Color4f componentColor, Vec3 cameraPos) {
        RenderUtils.drawBox((IntBoundingBox)structure.getBoundingBox(), (Vec3)cameraPos, (Color4f)mainColor, (BufferBuilder)BUFFER_1, (BufferBuilder)BUFFER_2);
        ImmutableList<IntBoundingBox> components = structure.getComponents();
        if (!(components.isEmpty() || components.size() <= 1 && MiscUtils.areBoxesEqual((IntBoundingBox)components.get(0), structure.getBoundingBox()))) {
            for (IntBoundingBox bb : components) {
                RenderUtils.drawBox((IntBoundingBox)bb, (Vec3)cameraPos, (Color4f)componentColor, (BufferBuilder)BUFFER_1, (BufferBuilder)BUFFER_2);
            }
        }
    }

    private List<StructureData> getStructuresToRender(BlockPos playerPos, int maxRange) {
        ArrayListMultimap<StructureType, StructureData> structures = DataStorage.getInstance().getCopyOfStructureData();
        ArrayList<StructureData> data = new ArrayList<StructureData>();
        for (StructureType type : structures.keySet()) {
            if (!type.isEnabled()) continue;
            for (StructureData structure : structures.get((Object)type)) {
                if (!MiscUtils.isStructureWithinRange(structure.getBoundingBox(), playerPos, maxRange)) continue;
                data.add(structure);
            }
        }
        return data;
    }
}

