/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererRegion
extends OverlayRendererBase {
    protected static boolean needsUpdate = true;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_REGION_FILE.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        if (needsUpdate) {
            return true;
        }
        int ex = (int)Math.floor(entity.m_20185_());
        int ez = (int)Math.floor(entity.m_20189_());
        int lx = this.lastUpdatePos.m_123341_();
        int lz = this.lastUpdatePos.m_123343_();
        return ex >> 9 != lx >> 9 || ez >> 9 != lz >> 9 || Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85815_);
        BUFFER_2.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
        Level world = entity.m_20193_();
        int minY = world != null ? world.m_141937_() : -64;
        int maxY = world != null ? world.m_151558_() : 320;
        int rx = Mth.m_14107_((double)entity.m_20185_()) & 0xFFFFFE00;
        int rz = Mth.m_14107_((double)entity.m_20189_()) & 0xFFFFFE00;
        BlockPos pos1 = new BlockPos(rx, minY, rz);
        BlockPos pos2 = new BlockPos(rx + 511, maxY, rz + 511);
        Color4f color = Configs.Colors.REGION_OVERLAY_COLOR.getColor();
        RenderUtils.renderWallsWithLines(pos1, pos2, cameraPos, 16.0, 16.0, true, color, BUFFER_1, BUFFER_2);
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }
}

