/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.LightLevelMarkerMode;
import fi.dy.masa.minihud.util.LightLevelNumberMode;
import fi.dy.masa.minihud.util.LightLevelRenderCondition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class OverlayRendererLightLevel
extends OverlayRendererBase {
    public static final OverlayRendererLightLevel INSTANCE = new OverlayRendererLightLevel();
    private static final ResourceLocation TEXTURE_NUMBERS = new ResourceLocation("bocchud", "textures/misc/light_level_numbers.png");
    private final List<LightLevelInfo> lightInfos = new ArrayList<LightLevelInfo>();
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private Direction lastDirection = Direction.NORTH;
    private static boolean tagsBroken;
    private static boolean needsUpdate;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public static void reset() {
        tagsBroken = false;
    }

    @Override
    public boolean shouldRender(Minecraft mc) {
        return RendererToggle.OVERLAY_LIGHT_LEVEL.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(Entity entity, Minecraft mc) {
        return needsUpdate || this.lastUpdatePos == null || Math.abs(entity.m_20185_() - (double)this.lastUpdatePos.m_123341_()) > 4.0 || Math.abs(entity.m_20186_() - (double)this.lastUpdatePos.m_123342_()) > 4.0 || Math.abs(entity.m_20189_() - (double)this.lastUpdatePos.m_123343_()) > 4.0 || Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() && this.lastDirection != entity.m_6350_();
    }

    @Override
    public void update(Vec3 cameraPos, Entity entity, Minecraft mc) {
        BlockPos pos = PositionUtils.getEntityBlockPos((Entity)entity);
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.m_166779_(renderQuads.getGlMode(), DefaultVertexFormat.f_85819_);
        BUFFER_2.m_166779_(renderLines.getGlMode(), DefaultVertexFormat.f_85815_);
        this.updateLightLevels((Level)mc.f_91073_, pos);
        this.renderLightLevels(cameraPos, mc);
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        this.lastUpdatePos = pos;
        this.lastDirection = entity.m_6350_();
        needsUpdate = false;
    }

    @Override
    protected void preRender() {
        super.preRender();
        RenderUtils.bindTexture((ResourceLocation)TEXTURE_NUMBERS);
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_, GameRenderer::m_172820_);
        this.allocateBuffer(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_, GameRenderer::m_172811_);
    }

    private void renderLightLevels(Vec3 cameraPos, Minecraft mc) {
        int count = this.lightInfos.size();
        if (count > 0) {
            BufferBuilder bufferQuads = BUFFER_1;
            BufferBuilder bufferLines = BUFFER_2;
            Direction numberFacing = Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() ? mc.f_91074_.m_6350_() : Direction.NORTH;
            LightLevelNumberMode numberMode = (LightLevelNumberMode)Configs.Generic.LIGHT_LEVEL_NUMBER_MODE.getOptionListValue();
            LightLevelMarkerMode markerMode = (LightLevelMarkerMode)Configs.Generic.LIGHT_LEVEL_MARKER_MODE.getOptionListValue();
            boolean useColoredNumbers = Configs.Generic.LIGHT_LEVEL_COLORED_NUMBERS.getBooleanValue();
            int safeThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_SAFE.getIntegerValue();
            int dimThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD_DIM.getIntegerValue();
            if (numberMode == LightLevelNumberMode.BLOCK || numberMode == LightLevelNumberMode.BOTH) {
                this.renderNumbers(cameraPos, LightLevelNumberMode.BLOCK, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_X, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_Y, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_LIT, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_DIM, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_DARK, useColoredNumbers, safeThreshold, dimThreshold, numberFacing, bufferQuads);
            }
            if (numberMode == LightLevelNumberMode.SKY || numberMode == LightLevelNumberMode.BOTH) {
                this.renderNumbers(cameraPos, LightLevelNumberMode.SKY, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_X, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_Y, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_LIT, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_DIM, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_DARK, useColoredNumbers, safeThreshold, dimThreshold, numberFacing, bufferQuads);
            }
            if (markerMode == LightLevelMarkerMode.SQUARE) {
                this.renderMarkers(this::renderLightLevelSquare, cameraPos, safeThreshold, dimThreshold, bufferLines);
            } else if (markerMode == LightLevelMarkerMode.CROSS) {
                this.renderMarkers(this::renderLightLevelCross, cameraPos, safeThreshold, dimThreshold, bufferLines);
            }
        }
    }

    private void renderNumbers(Vec3 cameraPos, LightLevelNumberMode mode, IConfigDouble cfgOffX, IConfigDouble cfgOffZ, ConfigColor cfgColorLit, ConfigColor cfgColorDim, ConfigColor cfgColorDark, boolean useColoredNumbers, int safeThreshold, int dimThreshold, Direction numberFacing, BufferBuilder buffer) {
        Color4f colorDark;
        Color4f colorDim;
        Color4f colorLit;
        double tmpX;
        double ox = cfgOffX.getDoubleValue();
        double oz = cfgOffZ.getDoubleValue();
        double offsetY = Configs.Generic.LIGHT_LEVEL_RENDER_OFFSET.getDoubleValue();
        double tmpZ = switch (numberFacing) {
            case Direction.NORTH -> {
                tmpX = -ox;
                yield -oz;
            }
            case Direction.SOUTH -> {
                tmpX = ox;
                yield oz;
            }
            case Direction.WEST -> {
                tmpX = -oz;
                yield ox;
            }
            case Direction.EAST -> {
                tmpX = oz;
                yield -ox;
            }
            default -> {
                tmpX = -ox;
                yield -oz;
            }
        };
        if (useColoredNumbers) {
            colorLit = cfgColorLit.getColor();
            colorDim = cfgColorDim.getColor();
            colorDark = cfgColorDark.getColor();
        } else {
            colorDim = colorLit = Color4f.fromColor((int)-1);
            colorDark = colorLit;
        }
        this.renderLightLevelNumbers(tmpX + cameraPos.f_82479_, cameraPos.f_82480_ - offsetY, tmpZ + cameraPos.f_82481_, numberFacing, safeThreshold, dimThreshold, mode, colorLit, colorDim, colorDark, buffer);
    }

    private void renderMarkers(IMarkerRenderer renderer, Vec3 cameraPos, int safeThreshold, int dimThreshold, BufferBuilder buffer) {
        Color4f colorBlockLit = Configs.Colors.LIGHT_LEVEL_MARKER_BLOCK_LIT.getColor();
        Color4f colorDim = Configs.Colors.LIGHT_LEVEL_MARKER_DIM.getColor();
        Color4f colorSkyLit = Configs.Colors.LIGHT_LEVEL_MARKER_SKY_LIT.getColor();
        Color4f colorDark = Configs.Colors.LIGHT_LEVEL_MARKER_DARK.getColor();
        LightLevelRenderCondition condition = (LightLevelRenderCondition)Configs.Generic.LIGHT_LEVEL_MARKER_CONDITION.getOptionListValue();
        double markerSize = Configs.Generic.LIGHT_LEVEL_MARKER_SIZE.getDoubleValue();
        double offsetX = cameraPos.f_82479_;
        double offsetY = cameraPos.f_82480_ - Configs.Generic.LIGHT_LEVEL_RENDER_OFFSET.getDoubleValue();
        double offsetZ = cameraPos.f_82481_;
        double offset1 = (1.0 - markerSize) / 2.0;
        double offset2 = 1.0 - offset1;
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        for (LightLevelInfo info : this.lightInfos) {
            if (!condition.shouldRender(info.block, dimThreshold, safeThreshold)) continue;
            long pos = info.pos;
            double x = (double)BlockPos.m_121983_((long)pos) - offsetX;
            double y = (double)(autoHeight ? info.y : (float)BlockPos.m_122008_((long)pos)) - offsetY;
            double z = (double)BlockPos.m_122015_((long)pos) - offsetZ;
            Color4f color = info.block < safeThreshold ? (info.sky >= safeThreshold ? colorSkyLit : colorDark) : (info.block > dimThreshold ? colorBlockLit : colorDim);
            renderer.render(x, y, z, color, offset1, offset2, buffer);
        }
    }

    private void renderLightLevelNumbers(double dx, double dy, double dz, Direction facing, int safeThreshold, int dimThreshold, LightLevelNumberMode numberMode, Color4f colorLit, Color4f colorDim, Color4f colorDark, BufferBuilder buffer) {
        LightLevelRenderCondition condition = (LightLevelRenderCondition)Configs.Generic.LIGHT_LEVEL_NUMBER_CONDITION.getOptionListValue();
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        for (LightLevelInfo info : this.lightInfos) {
            byte lightLevel;
            if (!condition.shouldRender(info.block, dimThreshold, safeThreshold)) continue;
            long pos = info.pos;
            double x = (double)BlockPos.m_121983_((long)pos) - dx;
            double y = (double)(autoHeight ? info.y : (float)BlockPos.m_122008_((long)pos)) - dy;
            double z = (double)BlockPos.m_122015_((long)pos) - dz;
            byte by = lightLevel = numberMode == LightLevelNumberMode.BLOCK ? info.block : info.sky;
            Color4f color = lightLevel < safeThreshold ? colorDark : (lightLevel > dimThreshold ? colorLit : colorDim);
            this.renderLightLevelTextureColor(x, y, z, facing, lightLevel, color, buffer);
        }
    }

    private void renderLightLevelTextureColor(double x, double y, double z, Direction facing, int lightLevel, Color4f color, BufferBuilder buffer) {
        float w = 0.25f;
        float u = (float)(lightLevel & 3) * w;
        float v = (float)(lightLevel >> 2) * w;
        y += 0.005;
        switch (facing) {
            case NORTH: {
                buffer.m_5483_(x, y, z).m_7421_(u, v).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x, y, z + 1.0).m_7421_(u, v + w).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x + 1.0, y, z + 1.0).m_7421_(u + w, v + w).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x + 1.0, y, z).m_7421_(u + w, v).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case SOUTH: {
                buffer.m_5483_(x + 1.0, y, z + 1.0).m_7421_(u, v).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x + 1.0, y, z).m_7421_(u, v + w).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x, y, z).m_7421_(u + w, v + w).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x, y, z + 1.0).m_7421_(u + w, v).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case EAST: {
                buffer.m_5483_(x + 1.0, y, z).m_7421_(u, v).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x, y, z).m_7421_(u, v + w).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x, y, z + 1.0).m_7421_(u + w, v + w).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x + 1.0, y, z + 1.0).m_7421_(u + w, v).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
            case WEST: {
                buffer.m_5483_(x, y, z + 1.0).m_7421_(u, v).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x + 1.0, y, z + 1.0).m_7421_(u, v + w).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x + 1.0, y, z).m_7421_(u + w, v + w).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                buffer.m_5483_(x, y, z).m_7421_(u + w, v).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
                break;
            }
        }
    }

    private void renderLightLevelCross(double x, double y, double z, Color4f color, double offset1, double offset2, BufferBuilder buffer) {
        buffer.m_5483_(x + offset1, y += 0.005, z + offset1).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset2, y, z + offset2).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset1, y, z + offset2).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset2, y, z + offset1).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    private void renderLightLevelSquare(double x, double y, double z, Color4f color, double offset1, double offset2, BufferBuilder buffer) {
        buffer.m_5483_(x + offset1, y += 0.005, z + offset1).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset1, y, z + offset2).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset1, y, z + offset2).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset2, y, z + offset2).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset2, y, z + offset2).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset2, y, z + offset1).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset2, y, z + offset1).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
        buffer.m_5483_(x + offset1, y, z + offset1).m_85950_(color.r, color.g, color.b, color.a).m_5752_();
    }

    private void updateLightLevels(Level world, BlockPos center) {
        this.lightInfos.clear();
        int radius = Configs.Generic.LIGHT_LEVEL_RANGE.getIntegerValue();
        int minX = center.m_123341_() - radius;
        int minY = center.m_123342_() - radius;
        int minZ = center.m_123343_() - radius;
        int maxX = center.m_123341_() + radius;
        int maxY = center.m_123342_() + radius;
        int maxZ = center.m_123343_() + radius;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        LevelLightEngine lightingProvider = world.m_7726_().m_7827_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int worldTopHeight = world.m_151558_();
        boolean collisionCheck = Configs.Generic.LIGHT_LEVEL_COLLISION_CHECK.getBooleanValue();
        boolean underWater = Configs.Generic.LIGHT_LEVEL_UNDER_WATER.getBooleanValue();
        boolean autoHeight = Configs.Generic.LIGHT_LEVEL_AUTO_HEIGHT.getBooleanValue();
        boolean skipBlockCheck = Configs.Generic.LIGHT_LEVEL_SKIP_BLOCK_CHECK.getBooleanValue();
        for (int cx = minCX; cx <= maxCX; ++cx) {
            int startX = Math.max(cx << 4, minX);
            int endX = Math.min((cx << 4) + 15, maxX);
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                int startZ = Math.max(cz << 4, minZ);
                int endZ = Math.min((cz << 4) + 15, maxZ);
                LevelChunk chunk = world.m_6325_(cx, cz);
                int startY = Math.max(minY, world.m_141937_());
                int endY = Math.min(maxY, chunk.m_62098_() + 15 + 1);
                for (int y = startY; y <= endY; ++y) {
                    LevelChunkSection section;
                    if (y > startY && (section = chunk.m_183278_(chunk.m_151564_(y - 1))).m_188008_()) continue;
                    for (int x = startX; x <= endX; ++x) {
                        for (int z = startZ; z <= endZ; ++z) {
                            if (!this.canSpawnAtWrapper(x, y, z, (ChunkAccess)chunk, world, skipBlockCheck)) continue;
                            mutablePos.m_122178_(x, y, z);
                            BlockState state = chunk.m_8055_((BlockPos)mutablePos);
                            if (collisionCheck && !state.m_60812_((BlockGetter)chunk, (BlockPos)mutablePos).m_83281_() || !underWater && !state.m_60819_().m_76178_()) continue;
                            int block = y < worldTopHeight ? lightingProvider.m_75814_(LightLayer.BLOCK).m_7768_((BlockPos)mutablePos) : 0;
                            int sky = y < worldTopHeight ? lightingProvider.m_75814_(LightLayer.SKY).m_7768_((BlockPos)mutablePos) : 15;
                            double topY = state.m_60808_((BlockGetter)chunk, (BlockPos)mutablePos).m_83297_(Direction.Axis.Y);
                            if (autoHeight && !(topY < 1.0)) continue;
                            float posY = topY >= 0.0 ? (float)y + (float)topY : (float)y;
                            this.lightInfos.add(new LightLevelInfo(mutablePos.m_121878_(), posY, block, sky));
                        }
                    }
                }
            }
        }
    }

    private boolean canSpawnAtWrapper(int x, int y, int z, ChunkAccess chunk, Level world, boolean skipBlockCheck) {
        try {
            return this.canSpawnAt(x, y, z, chunk, world, skipBlockCheck);
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"This dimension seems to have missing block tag data, the light level will not use the normal block spawnability checks in this dimension. This is known to happen on some Waterfall/BungeeCord/ViaVersion/whatever setups that have an older MC version at the back end.", (Object[])new Object[0]);
            tagsBroken = true;
            return false;
        }
    }

    private boolean canSpawnAt(int x, int y, int z, ChunkAccess chunk, Level world, boolean skipBlockCheck) {
        this.mutablePos.m_122178_(x, y - 1, z);
        BlockState stateDown = chunk.m_8055_((BlockPos)this.mutablePos);
        if (skipBlockCheck && !stateDown.m_60795_() && !(stateDown.m_60734_() instanceof LiquidBlock) || stateDown.m_60643_((BlockGetter)world, (BlockPos)this.mutablePos, EntityType.f_20558_)) {
            this.mutablePos.m_122178_(x, y, z);
            BlockState state = chunk.m_8055_((BlockPos)this.mutablePos);
            if (OverlayRendererLightLevel.isClearForSpawnWrapper((BlockGetter)world, (BlockPos)this.mutablePos, state, state.m_60819_(), EntityType.f_20497_)) {
                this.mutablePos.m_122178_(x, y + 1, z);
                BlockState stateUp1 = chunk.m_8055_((BlockPos)this.mutablePos);
                return OverlayRendererLightLevel.isClearForSpawnWrapper((BlockGetter)world, (BlockPos)this.mutablePos, stateUp1, state.m_60819_(), EntityType.f_20497_);
            }
            if (state.m_60819_().m_205070_(FluidTags.f_13131_)) {
                this.mutablePos.m_122178_(x, y + 1, z);
                BlockState stateUp1 = chunk.m_8055_((BlockPos)this.mutablePos);
                return stateUp1.m_60819_().m_205070_(FluidTags.f_13131_) && !chunk.m_8055_((BlockPos)this.mutablePos.m_122178_(x, y + 2, z)).m_60796_((BlockGetter)world, (BlockPos)this.mutablePos);
            }
        }
        return false;
    }

    public static boolean isClearForSpawnWrapper(BlockGetter blockView, BlockPos pos, BlockState state, FluidState fluidState, EntityType<?> entityType) {
        return tagsBroken ? OverlayRendererLightLevel.isClearForSpawnStripped(blockView, pos, state, fluidState, entityType) : NaturalSpawner.m_47056_((BlockGetter)blockView, (BlockPos)pos, (BlockState)state, (FluidState)fluidState, entityType);
    }

    public static boolean isClearForSpawnStripped(BlockGetter blockView, BlockPos pos, BlockState state, FluidState fluidState, EntityType<?> entityType) {
        return !state.m_60838_(blockView, pos) && !state.m_60803_() && fluidState.m_76178_();
    }

    private static interface IMarkerRenderer {
        public void render(double var1, double var3, double var5, Color4f var7, double var8, double var10, BufferBuilder var12);
    }

    public static class LightLevelInfo {
        public final long pos;
        public final byte block;
        public final byte sky;
        public final float y;

        public LightLevelInfo(long pos, float y, int block, int sky) {
            this.pos = pos;
            this.y = y;
            this.block = (byte)block;
            this.sky = (byte)sky;
        }
    }
}

