/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.BaseBlockRangeOverlay;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.ConduitExtra;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class OverlayRendererConduitRange
extends BaseBlockRangeOverlay<ConduitBlockEntity> {
    public static final OverlayRendererConduitRange INSTANCE = new OverlayRendererConduitRange();

    public OverlayRendererConduitRange() {
        super((IConfigBoolean)RendererToggle.OVERLAY_CONDUIT_RANGE, BlockEntityType.f_58941_, ConduitBlockEntity.class);
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(VertexFormat.Mode.QUADS);
    }

    @Override
    protected void startBuffers() {
        BUFFER_1.m_166779_(((RenderObjectBase)this.renderObjects.get(0)).getGlMode(), DefaultVertexFormat.f_85815_);
    }

    @Override
    protected void uploadBuffers() {
        ((RenderObjectBase)this.renderObjects.get(0)).uploadData(BUFFER_1);
    }

    @Override
    public void draw(PoseStack matrixStack, Matrix4f projMatrix) {
        this.preRender();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack, projMatrix);
        RenderSystem.polygonMode((int)1032, (int)6913);
        RenderSystem.disableBlend();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack, projMatrix);
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.enableBlend();
        this.postRender();
    }

    @Override
    protected void renderBlockRange(Level world, BlockPos pos, ConduitBlockEntity be, Vec3 cameraPos) {
        if (!be.m_59216_()) {
            return;
        }
        int range = ((ConduitExtra)be).getStoredActivatingBlockCount() / 7 * 16;
        Color4f color = Configs.Colors.CONDUIT_RANGE_OVERLAY_COLOR.getColor();
        LongOpenHashSet positions = new LongOpenHashSet();
        Consumer<BlockPos.MutableBlockPos> positionCollector = p -> positions.add(p.m_121878_());
        SphereUtils.RingPositionTest test = this.getPositionTest(pos, range);
        SphereUtils.collectSpherePositions(positionCollector, test, pos, range);
        RenderUtils.renderCircleBlockPositions(positions, PositionUtils.ALL_DIRECTIONS, test, ShapeRenderType.OUTER_EDGE, new LayerRange(null), color, 0.0, cameraPos, BUFFER_1);
    }

    protected SphereUtils.RingPositionTest getPositionTest(BlockPos centerPos, int range) {
        Vec3 center = new Vec3((double)centerPos.m_123341_() + 0.5, (double)centerPos.m_123342_() + 0.5, (double)centerPos.m_123343_() + 0.5);
        double squareRange = range * range;
        return (x, y, z, dir) -> SphereUtils.isPositionInsideOrClosestToRadiusOnBlockRing(x, y, z, center, squareRange, Direction.EAST);
    }
}

