/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public abstract class OverlayRendererBase
implements IOverlayRenderer {
    protected static final BufferBuilder BUFFER_1 = new BufferBuilder(0x200000);
    protected static final BufferBuilder BUFFER_2 = new BufferBuilder(0x200000);
    protected final List<RenderObjectBase> renderObjects = new ArrayList<RenderObjectBase>();
    protected boolean renderThrough;
    protected boolean useCulling;
    protected float glLineWidth = 1.0f;
    @Nullable
    protected BlockPos lastUpdatePos = BlockPos.f_121853_;
    private Vec3 updateCameraPos = Vec3.f_82478_;

    @Override
    public final Vec3 getUpdatePosition() {
        return this.updateCameraPos;
    }

    @Override
    public final void setUpdatePosition(Vec3 cameraPosition) {
        this.updateCameraPos = cameraPosition;
    }

    protected void preRender() {
        RenderSystem.lineWidth((float)this.glLineWidth);
        if (this.renderThrough) {
            RenderSystem.disableDepthTest();
        }
        if (this.useCulling) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
    }

    protected void postRender() {
        if (this.renderThrough) {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.enableCull();
    }

    @Override
    public void draw(PoseStack matrixStack, Matrix4f projMatrix) {
        this.preRender();
        for (RenderObjectBase obj : this.renderObjects) {
            obj.draw(matrixStack, projMatrix);
        }
        this.postRender();
    }

    @Override
    public void deleteGlResources() {
        for (RenderObjectBase obj : this.renderObjects) {
            obj.deleteGlResources();
        }
        this.renderObjects.clear();
    }

    protected RenderObjectBase allocateBuffer(VertexFormat.Mode glMode) {
        return this.allocateBuffer(glMode, DefaultVertexFormat.f_85815_, GameRenderer::m_172811_);
    }

    protected RenderObjectBase allocateBuffer(VertexFormat.Mode glMode, VertexFormat format, Supplier<ShaderInstance> shader) {
        RenderObjectVbo obj = new RenderObjectVbo(glMode, format, shader);
        this.renderObjects.add(obj);
        return obj;
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(VertexFormat.Mode.QUADS);
        this.allocateBuffer(VertexFormat.Mode.DEBUG_LINES);
    }

    public void setRenderThrough(boolean renderThrough) {
        this.renderThrough = renderThrough;
    }

    public String getSaveId() {
        return "";
    }

    @Nullable
    public JsonObject toJson() {
        return null;
    }

    public void fromJson(JsonObject obj) {
    }
}

