/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.RenderContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class OverlayRenderer {
    private static long loginTime;
    private static boolean canRender;

    public static void resetRenderTimeout() {
        canRender = false;
        loginTime = System.currentTimeMillis();
    }

    public static void renderOverlays(PoseStack matrixStack, Matrix4f projMatrix, Minecraft mc) {
        Entity entity = EntityUtils.getCameraEntity();
        if (entity == null) {
            return;
        }
        if (!canRender) {
            if (System.currentTimeMillis() - loginTime >= 5000L || entity.m_20185_() != 8.5 || entity.m_20186_() != 65.0 || entity.m_20189_() != 8.5) {
                canRender = true;
            } else {
                return;
            }
        }
        if (RendererToggle.OVERLAY_BEACON_RANGE.getBooleanValue()) {
            mc.m_91307_().m_6521_(() -> "BeaconRangeHeldItem");
            OverlayRenderer.renderBeaconBoxForPlayerIfHoldingItem(entity, mc);
            mc.m_91307_().m_7238_();
        }
        RenderContainer.INSTANCE.render(entity, matrixStack, projMatrix, mc);
    }

    public static void renderBeaconBoxForPlayerIfHoldingItem(Entity entity, Minecraft mc) {
        Item item = mc.f_91074_.m_21205_().m_41720_();
        if (item instanceof BlockItem && ((BlockItem)item).m_40614_() == Blocks.f_50273_) {
            OverlayRenderer.renderBeaconBoxForPlayer(entity, mc);
            return;
        }
        item = mc.f_91074_.m_21205_().m_41720_();
        if (item instanceof BlockItem && ((BlockItem)item).m_40614_() == Blocks.f_50273_) {
            OverlayRenderer.renderBeaconBoxForPlayer(entity, mc);
        }
    }

    private static void renderBeaconBoxForPlayer(Entity entity, Minecraft mc) {
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        double x = Math.floor(entity.m_20185_()) - cameraPos.f_82479_;
        double y = Math.floor(entity.m_20186_()) - cameraPos.f_82480_;
        double z = Math.floor(entity.m_20189_()) - cameraPos.f_82481_;
        int level = mc.f_91074_.m_6144_() ? Math.min(4, mc.f_91074_.m_150109_().f_35977_ + 1) : 4;
        double range = level * 10 + 10;
        double minX = x - range;
        double minY = y - range;
        double minZ = z - range;
        double maxX = x + range + 1.0;
        double maxY = y + 4.0;
        double maxZ = z + range + 1.0;
        Color4f color = OverlayRendererBeaconRange.getColorForLevel(level);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderUtils.setupBlend();
        RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.applyModelViewMatrix();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)0.3f), (BufferBuilder)buffer);
        tessellator.m_85914_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)Color4f.fromColor((Color4f)color, (float)1.0f), (BufferBuilder)buffer);
        tessellator.m_85914_();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

